/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.buffer.impl;

import com.metamatrix.common.buffer.TupleSourceID;
import com.metamatrix.common.buffer.impl.BufferConfig;
import com.metamatrix.common.buffer.impl.BufferStats;
import com.metamatrix.common.buffer.impl.ManagedBatch;
import com.metamatrix.common.buffer.impl.TupleGroupInfo;
import com.metamatrix.common.log.LogManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MemoryState {
    private static ThreadLocal<Map<TupleSourceID, Map<Integer, ManagedBatch>>> PINNED_BY_THREAD = new ThreadLocal();
    static final int MEMORY_AVAILABLE = 1;
    static final int MEMORY_EXCEED_MAX = 2;
    static final int MEMORY_EXCEED_SESSION_MAX = 3;
    private BufferConfig config;
    private long memoryUsed = 0L;
    private Map<TupleSourceID, Map<Integer, ManagedBatch>> pinned = new HashMap<TupleSourceID, Map<Integer, ManagedBatch>>();
    private Set<ManagedBatch> unpinned = Collections.synchronizedSet(new LinkedHashSet());

    public MemoryState(BufferConfig config) {
        this.config = config;
    }

    public synchronized void fillStats(BufferStats stats) {
        stats.memoryUsed = this.memoryUsed;
        stats.memoryFree = this.config.getTotalAvailableMemory() - this.memoryUsed;
    }

    public synchronized long getMemoryUsed() {
        return this.memoryUsed;
    }

    public synchronized int reserveMemory(long bytes, TupleGroupInfo groupInfo) {
        long sessionMax = this.config.getMaxAvailableSession();
        if (sessionMax - groupInfo.getGroupMemoryUsed() < bytes) {
            return 3;
        }
        long max = this.config.getTotalAvailableMemory();
        if (max - this.memoryUsed < bytes) {
            return 2;
        }
        groupInfo.reserveMemory(bytes);
        this.memoryUsed += bytes;
        return 1;
    }

    public synchronized void releaseMemory(long bytes, TupleGroupInfo groupInfo) {
        groupInfo.releaseMemory(bytes);
        this.memoryUsed -= bytes;
    }

    public synchronized long getGroupMemoryUsed(TupleGroupInfo groupInfo) {
        return groupInfo.getGroupMemoryUsed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPinned(ManagedBatch batch) {
        MemoryState memoryState = this;
        synchronized (memoryState) {
            this.addPinnedInternal(this.pinned, batch);
        }
        Map<TupleSourceID, Map<Integer, ManagedBatch>> theadPinned = PINNED_BY_THREAD.get();
        if (theadPinned == null) {
            theadPinned = new HashMap<TupleSourceID, Map<Integer, ManagedBatch>>();
            PINNED_BY_THREAD.set(theadPinned);
        }
        this.addPinnedInternal(theadPinned, batch);
        if (LogManager.isMessageToBeRecorded((String)"BUFFER_MGR", (int)6)) {
            batch.captureCallStack();
        }
    }

    private void addPinnedInternal(Map<TupleSourceID, Map<Integer, ManagedBatch>> pinnedMap, ManagedBatch batch) {
        TupleSourceID tsID = batch.getTupleSourceID();
        Map<Integer, ManagedBatch> tsPinned = pinnedMap.get(tsID);
        if (tsPinned == null) {
            tsPinned = new HashMap<Integer, ManagedBatch>();
            pinnedMap.put(tsID, tsPinned);
        }
        tsPinned.put(new Integer(batch.getBeginRow()), batch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ManagedBatch removePinned(TupleSourceID tsID, int beginRow) {
        Map<TupleSourceID, Map<Integer, ManagedBatch>> theadPinned;
        ManagedBatch result = null;
        MemoryState memoryState = this;
        synchronized (memoryState) {
            result = this.removePinnedInternal(this.pinned, tsID, beginRow);
        }
        if (result != null && (theadPinned = PINNED_BY_THREAD.get()) != null) {
            this.removePinnedInternal(theadPinned, tsID, beginRow);
        }
        return result;
    }

    private ManagedBatch removePinnedInternal(Map<TupleSourceID, Map<Integer, ManagedBatch>> pinnedMap, TupleSourceID tsID, int beginRow) {
        Map<Integer, ManagedBatch> tsPinned = pinnedMap.get(tsID);
        if (tsPinned != null) {
            ManagedBatch mbatch = tsPinned.remove(new Integer(beginRow));
            if (tsPinned.size() == 0) {
                pinnedMap.remove(tsID);
            }
            return mbatch;
        }
        return null;
    }

    public void addUnpinned(ManagedBatch batch) {
        this.unpinned.add(batch);
    }

    public void removeUnpinned(ManagedBatch batch) {
        this.unpinned.remove(batch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<ManagedBatch> getAllUnpinned() {
        Set<ManagedBatch> set = this.unpinned;
        synchronized (set) {
            ArrayList<ManagedBatch> copy = new ArrayList<ManagedBatch>(this.unpinned);
            return copy.iterator();
        }
    }

    public synchronized Map<TupleSourceID, Map<Integer, ManagedBatch>> getAllPinned() {
        return new HashMap<TupleSourceID, Map<Integer, ManagedBatch>>(this.pinned);
    }

    public Map<TupleSourceID, Map<Integer, ManagedBatch>> getPinnedByCurrentThread() {
        return PINNED_BY_THREAD.get();
    }
}

