/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.processor.relational;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.MetaMatrixProcessingException;
import com.metamatrix.api.exception.query.CriteriaEvaluationException;
import com.metamatrix.common.buffer.BlockedException;
import com.metamatrix.common.buffer.TupleBatch;
import com.metamatrix.query.eval.CriteriaEvaluator;
import com.metamatrix.query.eval.LookupEvaluator;
import com.metamatrix.query.processor.relational.RelationalNode;
import com.metamatrix.query.sql.lang.Criteria;
import com.metamatrix.query.util.CommandContext;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SelectNode
extends RelationalNode {
    private Criteria criteria;
    private Map elementMap;
    private boolean blockedOnCriteria = false;
    private boolean blockedOnPrepare = false;
    private TupleBatch blockedBatch = null;
    private int blockedRow = 0;

    public SelectNode(int nodeID) {
        super(nodeID);
    }

    public void reset() {
        super.reset();
        this.blockedOnCriteria = false;
        this.blockedOnPrepare = false;
        this.blockedBatch = null;
        this.blockedRow = 0;
    }

    public void setCriteria(Criteria criteria) {
        this.criteria = criteria;
    }

    public Criteria getCriteria() {
        return this.criteria;
    }

    public void open() throws MetaMatrixComponentException {
        super.open();
        if (this.elementMap == null) {
            this.elementMap = this.createLookupMap(this.getChildren()[0].getElements());
        }
    }

    public TupleBatch nextBatchDirect() throws BlockedException, MetaMatrixComponentException, MetaMatrixProcessingException {
        TupleBatch batch = this.blockedBatch;
        if (!this.blockedOnCriteria && !this.blockedOnPrepare) {
            batch = this.getChildren()[0].nextBatch();
        }
        boolean doPrepareToProcessTuple = !this.blockedOnCriteria;
        int row = this.blockedRow;
        if (!this.blockedOnCriteria && !this.blockedOnPrepare) {
            row = batch.getBeginRow();
        } else {
            this.blockedOnCriteria = false;
            this.blockedOnPrepare = false;
            this.blockedBatch = null;
            this.blockedRow = 0;
        }
        while (row <= batch.getEndRow()) {
            List tuple = batch.getTuple(row);
            if (doPrepareToProcessTuple) {
                try {
                    this.prepareToProcessTuple(this.elementMap, tuple);
                }
                catch (BlockedException e) {
                    this.blockedOnPrepare = true;
                    this.blockedBatch = batch;
                    this.blockedRow = row;
                    throw e;
                }
            }
            try {
                if (CriteriaEvaluator.evaluate((Criteria)this.criteria, (Map)this.elementMap, (List)tuple, (LookupEvaluator)this.getDataManager(), (CommandContext)this.getContext())) {
                    this.addBatchRow(this.projectTuple(this.elementMap, tuple, this.getElements()));
                }
            }
            catch (CriteriaEvaluationException e) {
                throw new MetaMatrixComponentException((Throwable)e, e.getMessage());
            }
            catch (BlockedException e) {
                this.blockedOnCriteria = true;
                this.blockedBatch = batch;
                this.blockedRow = row;
                throw e;
            }
            ++row;
        }
        if (batch.getTerminationFlag()) {
            this.terminateBatches();
        }
        return this.pullBatch();
    }

    protected void prepareToProcessTuple(Map elementMap, List currentTuple) throws BlockedException, MetaMatrixComponentException, MetaMatrixProcessingException {
    }

    protected void getNodeString(StringBuffer str) {
        super.getNodeString(str);
        str.append(this.criteria);
    }

    public Object clone() {
        SelectNode clonedNode = new SelectNode(super.getID());
        this.copy(this, clonedNode);
        return clonedNode;
    }

    protected void copy(SelectNode source, SelectNode target) {
        super.copy(source, target);
        if (this.criteria != null) {
            target.criteria = (Criteria)source.criteria.clone();
        }
        if (this.elementMap != null) {
            target.elementMap = new HashMap(source.elementMap);
        }
    }

    public Map getDescriptionProperties() {
        Map props = super.getDescriptionProperties();
        props.put("type", "Select");
        props.put("criteria", this.criteria.toString());
        return props;
    }
}

