/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.comm.platform.socket;

import com.metamatrix.admin.api.exception.AdminComponentException;
import com.metamatrix.admin.api.exception.AdminException;
import com.metamatrix.admin.api.server.ServerAdmin;
import com.metamatrix.admin.util.AdminMethodRoleResolver;
import com.metamatrix.admin.util.IAdminMethodRoleResolver;
import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.comm.ServerListenerRegistry;
import com.metamatrix.common.comm.api.ClientConnection;
import com.metamatrix.common.comm.api.Message;
import com.metamatrix.common.comm.api.ServerListener;
import com.metamatrix.common.comm.exception.ApplicationException;
import com.metamatrix.common.comm.exception.CommunicationException;
import com.metamatrix.common.comm.platform.CommPlatformPlugin;
import com.metamatrix.common.comm.platform.SocketConstants;
import com.metamatrix.common.comm.platform.server.AdminAuthorizationInterceptor;
import com.metamatrix.common.comm.platform.server.MessageFilterServiceAgent;
import com.metamatrix.common.comm.platform.socket.ISocketVMController;
import com.metamatrix.common.comm.platform.socket.SocketLog;
import com.metamatrix.common.comm.platform.socket.SocketLogon;
import com.metamatrix.common.comm.platform.socket.server.SocketListener;
import com.metamatrix.common.comm.platform.socket.server.SocketServerWorkerFactory;
import com.metamatrix.common.comm.service.SocketService;
import com.metamatrix.common.config.CurrentConfiguration;
import com.metamatrix.common.config.api.Host;
import com.metamatrix.common.log.DbLogListener;
import com.metamatrix.common.log.DbWriterException;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.queue.QueueWorkerFactory;
import com.metamatrix.common.queue.WorkerPool;
import com.metamatrix.common.queue.WorkerPoolStats;
import com.metamatrix.common.util.PropertiesUtils;
import com.metamatrix.common.util.RemoteUtil;
import com.metamatrix.common.util.VMNaming;
import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.core.factory.FactoryStrategy;
import com.metamatrix.core.factory.ThreadLocalFactoryStrategy;
import com.metamatrix.core.log.LogListener;
import com.metamatrix.core.proxy.DefaultTerminalServiceInterceptor;
import com.metamatrix.core.proxy.SecureTerminalServiceInterceptor;
import com.metamatrix.core.proxy.SecurityContextFactory;
import com.metamatrix.core.proxy.ServerSecurityServiceInterceptor;
import com.metamatrix.core.proxy.ServiceInterceptor;
import com.metamatrix.core.proxy.ServiceInterfaceInterceptorStruct;
import com.metamatrix.core.proxy.TerminalServiceInterceptor;
import com.metamatrix.core.util.FileUtils;
import com.metamatrix.internal.core.log.PlatformLog;
import com.metamatrix.platform.PlatformPlugin;
import com.metamatrix.platform.admin.api.AuthorizationAdminAPI;
import com.metamatrix.platform.admin.api.ConfigurationAdminAPI;
import com.metamatrix.platform.admin.api.ExtensionSourceAdminAPI;
import com.metamatrix.platform.admin.api.MembershipAdminAPI;
import com.metamatrix.platform.admin.api.RuntimeStateAdminAPI;
import com.metamatrix.platform.admin.api.SessionAdminAPI;
import com.metamatrix.platform.admin.apiimpl.AdminHelper;
import com.metamatrix.platform.admin.apiimpl.AuthorizationAdminAPIImpl;
import com.metamatrix.platform.admin.apiimpl.ConfigurationAdminAPIImpl;
import com.metamatrix.platform.admin.apiimpl.ExtensionSourceAdminAPIImpl;
import com.metamatrix.platform.admin.apiimpl.IAdminHelper;
import com.metamatrix.platform.admin.apiimpl.MembershipAdminAPIImpl;
import com.metamatrix.platform.admin.apiimpl.RuntimeStateAdminAPIImpl;
import com.metamatrix.platform.admin.apiimpl.RuntimeStateListenerAgent;
import com.metamatrix.platform.admin.apiimpl.SessionAdminAPIImpl;
import com.metamatrix.platform.registry.MetaMatrixRegistry;
import com.metamatrix.platform.registry.MetaMatrixVMRegistry;
import com.metamatrix.platform.registry.exception.RegistryException;
import com.metamatrix.platform.security.api.ILogon;
import com.metamatrix.platform.security.api.service.ServerSessionService;
import com.metamatrix.platform.service.api.exception.ServiceException;
import com.metamatrix.platform.util.PlatformProxyHelper;
import com.metamatrix.platform.vm.controller.SocketListenerStats;
import com.metamatrix.platform.vm.controller.VMController;
import com.metamatrix.platform.vm.util.VMUtils;
import java.io.File;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Properties;

public class SocketVMController
extends VMController
implements ServerListenerRegistry,
SocketService,
ServerListener,
ISocketVMController {
    private static final String SERVER_PORT = "vm.socketPort";
    private static final String MAX_THREADS = "vm.maxThreads";
    private static final String TIMETOLIVE = "vm.timetolive";
    private static final String INPUT_BUFFER_SIZE = "vm.inputBufferSize";
    private static final String OUTPUT_BUFFER_SIZE = "vm.outputBufferSize";
    private static final int DEFAULT_SERVER_PORT = 31000;
    private static final int DEFAULT_MAX_THREADS = 15;
    private static final long DEFAULT_TIMETOLIVE = 15000L;
    private static final long DEFAULT_WAITFORSERVICES = 500L;
    private static final int DEFAULT_INPUT_BUFFER_SIZE = 102400;
    private static final int DEFAULT_OUTPUT_BUFFER_SIZE = 102400;
    private static final String CLASSNAME_SERVER_ADMIN_IMPL = "com.metamatrix.admin.server.ServerAdminImpl";
    private static final String CLASSNAME_QUERY_ADMIN_API = "com.metamatrix.server.admin.api.QueryAdminAPI";
    private static final String CLASSNAME_RUNTIME_METADATA_ADMIN_API = "com.metamatrix.server.admin.api.RuntimeMetadataAdminAPI";
    private static final String CLASSNAME_TRANSACTION_ADMIN_API = "com.metamatrix.server.admin.api.TransactionAdminAPI";
    private static final String CLASSNAME_QUERY_ADMIN_API_IMPL = "com.metamatrix.server.admin.apiimpl.QueryAdminAPIImpl";
    private static final String CLASSNAME_RUNTIME_METADATA_ADMIN_API_IMPL = "com.metamatrix.server.admin.apiimpl.RuntimeMetadataAdminAPIImpl";
    private static final String CLASSNAME_TRANSACTION_ADMIN_API_IMPL = "com.metamatrix.server.admin.apiimpl.TransactionAdminAPIImpl";
    private static final String METHODNAME_GET_INSTANCE = "getInstance";
    private static RuntimeStateListenerAgent messageRouter1 = new RuntimeStateListenerAgent(null);
    private static MessageFilterServiceAgent messageRouter2 = new MessageFilterServiceAgent(null);
    private InetAddress inetAddress;
    private int socketPort;
    private static final String SOCKET_WORKER_POOL_NAME = "SocketWorkerQueue";
    private SocketLog socketlog = SocketConstants.getLog((String)"CONTROLLER");
    private SocketListener listener;
    private WorkerPool workerPool;
    private ServerSessionService sessionServiceProxy = null;

    public SocketVMController(String vmName, String hostname, boolean startDeployedServices) throws Exception {
        super(vmName, hostname, startDeployedServices);
        this.inetAddress = InetAddress.getByName(this.getConfigHost().getHostAddress());
        this.registerSubSystemAdminAPIs();
        this.waitForServices();
        this.sessionServiceProxy = PlatformProxyHelper.getSessionServiceProxy((String)"ROUND_ROBIN_LOCAL_SELECTION_POLICY");
        this.registerILogonAPI();
        this.registerAdmin();
        this.startSocketListener();
    }

    private void registerSubSystemAdminAPIs() throws MetaMatrixComponentException {
        this.registerSubSystemAdminAPI(ConfigurationAdminAPI.class, ConfigurationAdminAPIImpl.getInstance());
        this.registerSubSystemAdminAPI(RuntimeStateAdminAPI.class, RuntimeStateAdminAPIImpl.getInstance());
        this.registerSubSystemAdminAPI(MembershipAdminAPI.class, MembershipAdminAPIImpl.getInstance());
        this.registerSubSystemAdminAPI(SessionAdminAPI.class, SessionAdminAPIImpl.getInstance());
        this.registerSubSystemAdminAPI(AuthorizationAdminAPI.class, AuthorizationAdminAPIImpl.getInstance());
        this.registerSubSystemAdminAPI(ExtensionSourceAdminAPI.class, ExtensionSourceAdminAPIImpl.getInstance());
        this.registerSubSystemAdminAPI(CLASSNAME_QUERY_ADMIN_API, CLASSNAME_QUERY_ADMIN_API_IMPL);
        this.registerSubSystemAdminAPI(CLASSNAME_RUNTIME_METADATA_ADMIN_API, CLASSNAME_RUNTIME_METADATA_ADMIN_API_IMPL);
        this.registerSubSystemAdminAPI(CLASSNAME_TRANSACTION_ADMIN_API, CLASSNAME_TRANSACTION_ADMIN_API_IMPL);
    }

    private void registerSubSystemAdminAPI(Class service, Object implementation) {
        SecurityContextFactory serverSecurityContextFactory = new SecurityContextFactory((FactoryStrategy)new ThreadLocalFactoryStrategy());
        ServerSecurityServiceInterceptor serverSecurityServiceInterceptor = new ServerSecurityServiceInterceptor(serverSecurityContextFactory);
        this.registerServiceInterceptor(service.getName(), service, new ServiceInterceptor[]{serverSecurityServiceInterceptor}, (TerminalServiceInterceptor)new SecureTerminalServiceInterceptor(serverSecurityContextFactory, implementation));
    }

    private void registerSubSystemAdminAPI(String serviceClassName, String implementationClassName) {
        try {
            Class<?> serviceClass = Class.forName(serviceClassName);
            Class<?> implementationClass = Class.forName(implementationClassName);
            Method getInstanceMethod = implementationClass.getMethod(METHODNAME_GET_INSTANCE, new Class[0]);
            Object implementation = getInstanceMethod.invoke(implementationClass, new Object[0]);
            this.registerSubSystemAdminAPI(serviceClass, implementation);
        }
        catch (Exception e) {
            throw new MetaMatrixRuntimeException((Throwable)e);
        }
    }

    private void registerAdmin() throws AdminException {
        Object[] param = new Object[]{messageRouter2};
        this.logMessage(CommPlatformPlugin.Util.getString("SocketVMController.0", param));
        AdminMethodRoleResolver adminMethodResolver = new AdminMethodRoleResolver();
        adminMethodResolver.init();
        SecurityContextFactory serverSecurityContextFactory = new SecurityContextFactory((FactoryStrategy)new ThreadLocalFactoryStrategy());
        ServerSecurityServiceInterceptor serverSecurityServiceInterceptor = new ServerSecurityServiceInterceptor(serverSecurityContextFactory);
        AdminHelper adminHelper = null;
        try {
            adminHelper = new AdminHelper();
        }
        catch (MetaMatrixComponentException err) {
            AdminComponentException e = new AdminComponentException(err.getMessage());
            e.setStackTrace(err.getStackTrace());
            throw e;
        }
        AdminAuthorizationInterceptor adminAuthInterceptor = new AdminAuthorizationInterceptor(serverSecurityContextFactory, (IAdminHelper)adminHelper, (IAdminMethodRoleResolver)adminMethodResolver);
        try {
            Class<?> clazz = Class.forName(CLASSNAME_SERVER_ADMIN_IMPL);
            ServerAdmin admin = (ServerAdmin)clazz.newInstance();
            this.registerServiceInterceptor(ServerAdmin.class.getName(), ServerAdmin.class, new ServiceInterceptor[]{serverSecurityServiceInterceptor, adminAuthInterceptor}, (TerminalServiceInterceptor)new SecureTerminalServiceInterceptor(serverSecurityContextFactory, (Object)admin));
        }
        catch (Exception e) {
            throw new MetaMatrixRuntimeException((Throwable)e);
        }
    }

    private void registerILogonAPI() {
        boolean firewallEnabled = RemoteUtil.isFirewallEnabled();
        List firewallAddresses = null;
        if (firewallEnabled) {
            firewallAddresses = RemoteUtil.getFirewallAddresses();
        }
        this.registerServiceInterceptor(ILogon.class.getName(), ILogon.class, new ServiceInterceptor[0], (TerminalServiceInterceptor)new DefaultTerminalServiceInterceptor((Object)new SocketLogon((ILogon)this.sessionServiceProxy, firewallAddresses)));
    }

    public String getHost() throws RemoteException {
        return this.getHostname();
    }

    public int getPort() throws RemoteException {
        return this.socketPort;
    }

    public InetAddress getInetAddress() throws RemoteException {
        return this.inetAddress;
    }

    public void connectionAdded(ClientConnection plainClientConnection) {
        messageRouter1.connectionAdded(plainClientConnection);
    }

    public void connectionRemoved(ClientConnection plainClientConnection) {
        messageRouter1.connectionRemoved(plainClientConnection);
    }

    public void receive(ClientConnection plainClientConnection, Message message, String messageKey) {
        messageRouter1.receive(plainClientConnection, message, messageKey);
    }

    public Message receive(ClientConnection plainClientConnection, Message message) throws ApplicationException {
        return messageRouter1.receive(plainClientConnection, message);
    }

    public ServerListener getServerListener() {
        return messageRouter1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStopVM(boolean now, boolean shutdown) throws ServiceException {
        if (this.workerPool != null) {
            try {
                this.workerPool.shutdown();
            }
            catch (Exception e) {
            }
            finally {
                this.workerPool = null;
            }
        }
        if (this.listener != null) {
            try {
                this.listener.stop();
            }
            catch (Exception exception) {
            }
            finally {
                this.listener = null;
            }
        }
        super.doStopVM(now, shutdown);
    }

    private void startSocketTransport(int port, String hostaddress, String bindaddress, int maxThreads, long timeToLive, int inputBufferSize, int outputBufferSize) {
        this.socketPort = port;
        Object[] param = new Object[]{SocketVMController.getVMName(), bindaddress, String.valueOf(this.socketPort)};
        VMNaming.setVMPort((int)this.socketPort);
        this.logMessage(CommPlatformPlugin.Util.getString("SocketVMController.1", param));
        this.workerPool = this.getSocketServerWorkerPool(maxThreads, timeToLive);
        this.listener = new SocketListener(port, hostaddress, bindaddress, (ServerListener)this, this.workerPool, this.socketlog, inputBufferSize, outputBufferSize);
        new Thread(this.getSocketListenerRunnable(this.listener, bindaddress, port), "SocketListener").start();
    }

    private Runnable getSocketListenerRunnable(final SocketListener listener, final String address, final int port) {
        return new Runnable(){

            public void run() {
                try {
                    listener.run();
                }
                catch (CommunicationException e) {
                    Object[] param = new Object[]{address, String.valueOf(port)};
                    SocketVMController.this.logError(CommPlatformPlugin.Util.getString("SocketVMController.2", param));
                    e.printStackTrace();
                    System.exit(1);
                }
            }
        };
    }

    private WorkerPool getSocketServerWorkerPool(int maxThreads, long timeToLive) {
        WorkerPool result = new WorkerPool(SOCKET_WORKER_POOL_NAME, (QueueWorkerFactory)new SocketServerWorkerFactory(), maxThreads, timeToLive);
        return result;
    }

    public void registerServiceInterceptor(String name, Class serviceName, ServiceInterceptor[] interceptor, TerminalServiceInterceptor terminal) {
        messageRouter2.addServiceInterface(name, new ServiceInterfaceInterceptorStruct(name, serviceName, interceptor, terminal));
    }

    public void setServerListener(ServerListener listenerFilter) {
        Object[] param = new Object[]{listenerFilter};
        this.logMessage(CommPlatformPlugin.Util.getString("SocketVMController.3", param));
        messageRouter2.setNextServerListener(listenerFilter);
    }

    public static void main(String[] args) {
        if (args.length >= 3 && args.length <= 4) {
            String vmName = args[0];
            String hostname = args[1];
            boolean startDeployedServices = args[2].equalsIgnoreCase("true");
            Host host = null;
            String logFile = "NotAssigned";
            try {
                File tf;
                host = CurrentConfiguration.findHost((String)hostname);
                if (host == null) {
                    System.err.println(PlatformPlugin.Util.getString("SocketVMController.5", (Object)hostname));
                    System.exit(-1);
                }
                VMNaming.setLogicalHostName((String)host.getFullName());
                VMNaming.setBindAddress((String)host.getBindAddress());
                VMNaming.setHostAddress((String)host.getHostAddress());
                String jgba = host.getProperty("jgroups.bind.address");
                if (jgba != null && jgba.length() > 0) {
                    VMNaming.setJGroupsBindAddress((String)jgba);
                }
                logFile = SocketVMController.buildVMLogPrefix((String)host.getName(), (String)vmName) + ".log";
                VMUtils.initializeVMLogFile((String)host.getLogDirectory(), (String)logFile);
                if (FileUtils.TEMP_DIRECTORY != null && !(tf = new File(FileUtils.TEMP_DIRECTORY)).exists()) {
                    tf.mkdirs();
                }
                SocketVMController.startDbLogging();
            }
            catch (Exception e) {
                System.out.println(PlatformPlugin.Util.getString("MSG.014.010.0012", (Object)logFile));
                e.printStackTrace();
                System.exit(1);
            }
            try {
                new SocketVMController(vmName, host.getFullName(), startDeployedServices);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(1);
            }
        } else {
            SocketVMController.doUsage();
            System.exit(1);
        }
    }

    private void startSocketListener() {
        Properties props = this.getVMProperties();
        int socketPort = PropertiesUtils.getIntProperty((Properties)props, (String)SERVER_PORT, (int)31000);
        int maxThreads = PropertiesUtils.getIntProperty((Properties)props, (String)MAX_THREADS, (int)15);
        long timeToLive = PropertiesUtils.getLongProperty((Properties)props, (String)TIMETOLIVE, (long)15000L);
        int inputBufferSize = PropertiesUtils.getIntProperty((Properties)props, (String)INPUT_BUFFER_SIZE, (int)102400);
        int outputBufferSize = PropertiesUtils.getIntProperty((Properties)props, (String)OUTPUT_BUFFER_SIZE, (int)102400);
        this.startSocketTransport(socketPort, VMNaming.getHostAddress(), VMNaming.getBindAddress(), maxThreads, timeToLive, inputBufferSize, outputBufferSize);
    }

    private void waitForServices() throws RegistryException, MetaMatrixComponentException {
        boolean isReady = false;
        while (!isReady) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            isReady = this.isServicesStarted(MetaMatrixVMRegistry.getInstance());
        }
    }

    private boolean isServicesStarted(MetaMatrixRegistry registry) throws MetaMatrixComponentException {
        boolean servicesStarted = false;
        List authServices = registry.getActiveServices("AuthorizationService");
        List sessionServices = registry.getActiveServices("SessionService");
        List membershipServices = registry.getActiveServices("MembershipService");
        List configurationServices = registry.getActiveServices("ConfigurationService");
        if (authServices.size() > 0 && sessionServices.size() > 0 && membershipServices.size() > 0 && configurationServices.size() > 0) {
            servicesStarted = true;
        }
        return servicesStarted;
    }

    protected ServerListenerRegistry getServerListenerRegistry() {
        Object[] params = new Object[]{((Object)((Object)this)).getClass().getName()};
        this.logMessage(CommPlatformPlugin.Util.getString("SocketVMController.4", params));
        return this;
    }

    protected static void doUsage() {
        System.out.println(CommPlatformPlugin.Util.getString("MSG.014.010.0010"));
        System.out.println(CommPlatformPlugin.Util.getString("MSG.014.010.0011"));
    }

    private static void startDbLogging() throws Exception, DbWriterException {
        Properties resourceProps = CurrentConfiguration.getResourceProperties((String)"Logging");
        Properties currentProps = CurrentConfiguration.getProperties();
        Properties resultsProps = PropertiesUtils.clone((Properties)currentProps, (Properties)resourceProps, (boolean)true, (boolean)false);
        DbLogListener dll = new DbLogListener(resultsProps);
        PlatformLog.getInstance().addListener((LogListener)dll);
        LogManager.logInfo((String)"CONTROLLER", (String)PlatformPlugin.Util.getString("MSG.014.010.0052"));
        VMController.initConfigurationEventListener((DbLogListener)dll);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("SocketVMController:  ");
        buffer.append(" messageRouter=").append(messageRouter1);
        buffer.append(" socketHost:").append(this.getHostname());
        buffer.append(" socketPort:").append(this.socketPort);
        return buffer.toString();
    }

    public SocketListenerStats getSocketListenerStats() {
        if (this.listener == null) {
            return null;
        }
        return this.listener.getStats();
    }

    public WorkerPoolStats getProcessPoolStats() {
        if (this.workerPool == null) {
            return null;
        }
        return this.workerPool.getStats();
    }

    public void registerMBean(Object mBean, String mBeanName) {
    }

    static {
        messageRouter1.setNextServerListener((ServerListener)messageRouter2);
    }
}

