/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.xml.choice;

import com.metamatrix.metamodels.xml.ChoiceErrorMode;
import com.metamatrix.metamodels.xml.ChoiceOption;
import com.metamatrix.metamodels.xml.XmlAll;
import com.metamatrix.metamodels.xml.XmlChoice;
import com.metamatrix.metamodels.xml.XmlContainerNode;
import com.metamatrix.metamodels.xml.XmlDocumentNode;
import com.metamatrix.metamodels.xml.XmlEntityHolder;
import com.metamatrix.metamodels.xml.XmlFragment;
import com.metamatrix.metamodels.xml.XmlSequence;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.mapping.choice.IChoiceObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;

public class XmlChoiceObject
implements IChoiceObject {
    private XmlChoice xcChoice;
    private Map optionSqlCriteriaMap = new HashMap();

    public XmlChoiceObject(XmlChoice xcChoice) {
        this.xcChoice = xcChoice;
    }

    public List getOrderedOptions() {
        List contents = this.xcChoice.getOrderedChoiceOptions();
        return contents;
    }

    public void setOrderedOptions(List lst) {
        this.xcChoice.setOrderedChoiceOptions(lst);
    }

    public String getName(Object option) {
        String result = null;
        if (option instanceof EObject && (result = ModelerCore.getModelEditor().getName((EObject)option)) == null) {
            if (option instanceof XmlSequence) {
                result = "sequence";
            } else if (option instanceof XmlChoice) {
                result = "choice";
            } else if (option instanceof XmlAll) {
                result = "all";
            }
        }
        if (result == null) {
            result = option.toString();
        }
        return result;
    }

    public String getCriteria(Object option) {
        return ((ChoiceOption)option).getChoiceCriteria();
    }

    public void setCriteria(Object option, String criteria) {
        ((ChoiceOption)option).setChoiceCriteria(criteria);
    }

    public String getSqlCriteria(Object option) {
        return (String)this.optionSqlCriteriaMap.get(option);
    }

    public void setSqlCriteria(Object option, String criteria) {
        this.optionSqlCriteriaMap.put(option, criteria);
    }

    public boolean isIncluded(Object option) {
        if (option instanceof XmlDocumentNode) {
            return !((XmlDocumentNode)option).isExcludeFromDocument();
        }
        if (option instanceof XmlContainerNode) {
            return !((XmlContainerNode)option).isExcludeFromDocument();
        }
        return true;
    }

    public void setIncluded(Object option, boolean b) {
        if (option instanceof XmlDocumentNode) {
            ((XmlDocumentNode)option).setExcludeFromDocument(!b);
        }
        if (option instanceof XmlContainerNode) {
            ((XmlContainerNode)option).setExcludeFromDocument(!b);
        }
    }

    public void move(int iNewPosition, Object object) {
        throw new UnsupportedOperationException();
    }

    public void move(int iNewPosition, int iOldPosition) {
        throw new UnsupportedOperationException();
    }

    public int getMinOccurs() {
        return this.xcChoice.getMinOccurs();
    }

    public String getDefaultErrorMode() {
        return this.xcChoice.getDefaultErrorMode().getName();
    }

    public void setDefaultErrorMode(String value) {
        this.xcChoice.setDefaultErrorMode(ChoiceErrorMode.get((String)value));
    }

    public String[] getValidErrorModeValues() {
        List lstValues = ChoiceErrorMode.VALUES;
        String[] saValues = new String[lstValues.size()];
        int iCounter = 0;
        for (ChoiceErrorMode cemTemp : lstValues) {
            saValues[iCounter++] = cemTemp.getName();
        }
        return saValues;
    }

    public Object getDefaultOption() {
        return this.xcChoice.getDefaultOption();
    }

    public void setDefaultOption(Object value) {
        this.xcChoice.setDefaultOption((ChoiceOption)value);
    }

    public EObject getRoot() {
        XmlEntityHolder eoRoot = null;
        int iCounter = 0;
        XmlEntityHolder eoTemp = this.xcChoice.getParent();
        while (true) {
            if (eoTemp instanceof XmlFragment) {
                eoRoot = eoTemp;
                break;
            }
            if (++iCounter > 100) break;
            eoTemp = eoTemp.eContainer();
        }
        return eoRoot;
    }

    public EObject getChoice() {
        return this.xcChoice;
    }

    public EObject getParent() {
        return this.xcChoice.getParent();
    }
}

