/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.config.spi.xml;

import com.metamatrix.common.config.StartupStateException;
import com.metamatrix.common.config.api.Configuration;
import com.metamatrix.common.config.api.ConfigurationID;
import com.metamatrix.common.config.api.ConfigurationModelContainer;
import com.metamatrix.common.config.api.exceptions.ConfigurationConnectionException;
import com.metamatrix.common.config.api.exceptions.ConfigurationException;
import com.metamatrix.common.config.api.exceptions.ConfigurationLockException;
import com.metamatrix.common.config.util.ConfigObjectsNotResolvableException;
import com.metamatrix.common.messaging.MessageBus;
import com.metamatrix.common.messaging.VMMessageBus;
import com.metamatrix.common.util.PropertiesUtils;
import com.metamatrix.core.event.EventObjectListener;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.platform.PlatformPlugin;
import com.metamatrix.platform.config.event.ConfigurationChangeEvent;
import com.metamatrix.platform.config.persistence.api.PersistentConnection;
import com.metamatrix.platform.config.persistence.api.PersistentConnectionFactory;
import com.metamatrix.platform.config.persistence.impl.ConfigurationModelAdapterImpl;
import com.metamatrix.platform.config.spi.xml.DelayConfigInitThread;
import com.metamatrix.platform.config.spi.xml.XMLConfigurationTransactionFactory;
import com.metamatrix.platform.config.transaction.ConfigTransaction;
import com.metamatrix.platform.config.transaction.ConfigTransactionException;
import com.metamatrix.platform.config.transaction.ConfigTransactionFactory;
import com.metamatrix.platform.config.transaction.ConfigTransactionLock;
import com.metamatrix.platform.config.transaction.ConfigTransactionLockException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class XMLConfigurationMgr {
    private static XMLConfigurationMgr mgr = null;
    private PersistentConnection connection = null;
    private PersistentConnectionFactory connFactory = null;
    private XMLConfigurationTransactionFactory transFactory;
    private Properties props = null;
    private static MessageBus messageBus = null;
    private Map configs = Collections.synchronizedMap(new HashMap(3));
    private Map transConfigs = Collections.synchronizedMap(new HashMap(3));
    private ConfigurationModelAdapterImpl adapter = new ConfigurationModelAdapterImpl();
    private String hostName = null;
    private Object lock = new Object();

    public static final synchronized XMLConfigurationMgr getInstance() {
        if (mgr == null) {
            XMLConfigurationMgr xmlMgr = new XMLConfigurationMgr();
            xmlMgr.init();
            mgr = xmlMgr;
        }
        return mgr;
    }

    private void init() {
    }

    public synchronized void init(Properties properties) throws ConfigurationException {
        if (this.props != null) {
            return;
        }
        if (properties == null) {
            Assertion.isNotNull((Object)properties, (String)PlatformPlugin.Util.getString("ERR.014.002.0113"));
        }
        this.props = PropertiesUtils.clone((Properties)properties, (boolean)false);
        Properties factoryProps = new Properties();
        factoryProps.putAll((Map<?, ?>)this.props);
        this.transFactory = new XMLConfigurationTransactionFactory(factoryProps);
        this.connFactory = PersistentConnectionFactory.createPersistentConnectionFactory((Properties)this.props);
        this.connection = this.connFactory.createPersistentConnection();
        ConfigurationModelContainer cmc = this.readModel(Configuration.NEXT_STARTUP_ID);
        if (cmc == null) {
            throw new ConfigurationException("ERR.014.002.0114", PlatformPlugin.Util.getString("ERR.014.002.0114", (Object)Configuration.NEXT_STARTUP_ID));
        }
        this.configs.put(cmc.getConfigurationID().getFullName(), cmc);
        try {
            ConfigurationModelContainer cmct = (ConfigurationModelContainer)cmc.clone();
            this.transConfigs.put(cmct.getConfigurationID().getFullName(), cmct);
        }
        catch (Exception ce) {
            throw new ConfigurationException((Throwable)ce, "ERR.014.002.0115", PlatformPlugin.Util.getString("ERR.014.002.0115", (Object)cmc.getConfigurationID()));
        }
        DelayConfigInitThread dl = new DelayConfigInitThread(this);
        dl.start();
    }

    void setMessageBus(VMMessageBus bus) {
        messageBus = bus;
    }

    void setHostName(String name) {
        this.hostName = name;
    }

    protected Properties getProperties() {
        return this.props;
    }

    public synchronized ConfigTransactionFactory getConfigTransactionFactory() {
        return this.transFactory;
    }

    public Date getServerStartupTime() throws ConfigurationException {
        return this.getConnection().getStartupTime();
    }

    public int getServerStartupState() throws ConfigurationException {
        return this.getConnection().getServerState();
    }

    public boolean isServerStarting() throws ConfigurationException {
        int startupState = this.getServerStartupState();
        return startupState == 1;
    }

    public boolean isServerStopped() throws ConfigurationException {
        int startupState = this.getServerStartupState();
        return startupState == 0;
    }

    public boolean isServerAvailable() throws ConfigurationException {
        int startupState = this.getServerStartupState();
        return startupState == 2;
    }

    protected synchronized void setServerStateToStarting(boolean force) throws StartupStateException, ConfigurationException {
        PersistentConnection conn = this.getConnection();
        if (force) {
            conn.setServerStarting(force);
        } else {
            conn.setServerStarting();
        }
    }

    protected synchronized void setServerStateToStopped() throws StartupStateException, ConfigurationException {
        this.getConnection().setServerStopped();
    }

    protected synchronized void setServerStateToStarted() throws StartupStateException, ConfigurationException {
        this.getConnection().setServerStarted();
    }

    protected ConfigTransactionLock getCurrentLock() throws ConfigTransactionLockException {
        return this.transFactory.getTransactionLockFactory().getCurrentConfigTransactionLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigurationModelContainer getConfigurationModel(ConfigurationID configID) throws ConfigurationException {
        ConfigurationModelContainer cmc = null;
        if (this.configs.containsKey(configID.getFullName())) {
            cmc = (ConfigurationModelContainer)this.configs.get(configID.getFullName());
        }
        if (cmc == null) {
            Object object = this.lock;
            synchronized (object) {
                cmc = this.readModel(configID);
                if (cmc == null) {
                    throw new ConfigurationException("ERR.014.002.0114", PlatformPlugin.Util.getString("ERR.014.002.0114", (Object)configID));
                }
                this.configs.put(cmc.getConfigurationID().getFullName(), cmc);
                try {
                    ConfigurationModelContainer cmct = (ConfigurationModelContainer)cmc.clone();
                    this.transConfigs.put(cmct.getConfigurationID().getFullName(), cmct);
                }
                catch (Exception ce) {
                    throw new ConfigurationException((Throwable)ce, "ERR.014.002.0116", PlatformPlugin.Util.getString("ERR.014.002.0116", (Object)configID));
                }
            }
        }
        return cmc;
    }

    private ConfigurationModelContainer readModel(ConfigurationID configID) throws ConfigurationException {
        return this.getConnection().read(configID);
    }

    private void writeModel(ConfigurationModelContainer model, String principal) throws ConfigurationException {
        try {
            this.adapter.validateModel(model);
        }
        catch (ConfigObjectsNotResolvableException nr) {
            throw new ConfigurationException((Throwable)nr);
        }
        this.getConnection().write(model, principal);
    }

    ConfigurationModelContainer getConfigurationModelForTransaction(ConfigurationID configID) throws ConfigurationException {
        Object object = this.lock;
        synchronized (object) {
            if (this.transConfigs.containsKey(configID.getFullName())) {
                return (ConfigurationModelContainer)this.transConfigs.get(configID.getFullName());
            }
            this.getConfigurationModel(configID);
            if (this.transConfigs.containsKey(configID.getFullName())) {
                return (ConfigurationModelContainer)this.transConfigs.get(configID.getFullName());
            }
            throw new ConfigurationException("ERR.014.002.0114", PlatformPlugin.Util.getString("ERR.014.002.0114", (Object)configID));
        }
    }

    public synchronized void rollbackTransaction() {
        this.connection.close();
        this.connection = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void applyTransaction(ConfigTransaction transaction) throws ConfigTransactionException {
        try {
            this.validateLock(transaction);
        }
        catch (ConfigurationLockException cle) {
            throw new ConfigTransactionException((Exception)((Object)cle), "ERR.014.002.0117", PlatformPlugin.Util.getString("ERR.014.002.0117"));
        }
        if (transaction == null) {
            ArgCheck.isNotNull((Object)transaction, (String)PlatformPlugin.Util.getString("ERR.014.002.0118"));
        }
        if (transaction.getAction() == -1 || transaction.getAction() == 3 || transaction.getAction() == 1) {
            if (transaction.getObjects() == null || transaction.getObjects().isEmpty()) {
                throw new ConfigTransactionException("ERR.014.002.0119", PlatformPlugin.Util.getString("ERR.014.002.0119"));
            }
            Collection models = transaction.getObjects();
            Object object = this.lock;
            synchronized (object) {
                for (Object obj : models) {
                    if (obj instanceof ConfigurationModelContainer) {
                        ConfigurationModelContainer config = (ConfigurationModelContainer)obj;
                        try {
                            this.writeModel(config, transaction.getLockAcquiredBy());
                            this.configs.put(config.getConfigurationID().getFullName(), config);
                            try {
                                ConfigurationModelContainer cmct = (ConfigurationModelContainer)config.clone();
                                this.transConfigs.put(cmct.getConfigurationID().getFullName(), cmct);
                                continue;
                            }
                            catch (Exception ce) {
                                throw new ConfigTransactionException(ce, "ERR.014.002.0115", PlatformPlugin.Util.getString("ERR.014.002.0115", (Object)config.getConfigurationID()));
                            }
                        }
                        catch (ConfigurationException ce) {
                            throw new ConfigTransactionException((Exception)((Object)ce), "ERR.014.002.0120", PlatformPlugin.Util.getString("ERR.014.002.0120", (Object)config.getConfigurationID()));
                        }
                    }
                    throw new ConfigTransactionException("ERR.014.002.0121", PlatformPlugin.Util.getString("ERR.014.002.0121", (Object)obj.getClass().getName()));
                }
            }
        }
        if (transaction.getAction() != 2 && messageBus != null) {
            try {
                messageBus.processEvent((EventObject)new ConfigurationChangeEvent((Object)this.hostName, 0));
            }
            catch (Exception e) {
                System.err.println(PlatformPlugin.Util.getString("ERR.014.002.0122", (Object)e.getMessage()));
            }
        }
    }

    public synchronized void performSystemInitialization(ConfigTransaction transaction) throws ConfigurationException, StartupStateException, ConfigurationLockException {
        this.validateLock(transaction);
        if (!this.isServerStarting()) {
            throw new StartupStateException(1, this.getServerStartupState());
        }
        ConfigurationModelContainer ns = this.readModel(Configuration.NEXT_STARTUP_ID);
        ConfigurationModelContainer st = ns.copyAs(Configuration.STARTUP_ID);
        transaction.addObjects((Object)ns.getConfigurationID().getFullName(), (Object)ns);
        transaction.addObjects((Object)st.getConfigurationID().getFullName(), (Object)st);
    }

    PersistentConnection getConnection() throws ConfigurationConnectionException {
        if (this.connection == null) {
            try {
                this.connection = this.connFactory.createPersistentConnection();
            }
            catch (ConfigurationException e) {
                throw new ConfigurationConnectionException((Throwable)e);
            }
        }
        if (this.connection.isClosed()) {
            try {
                this.connection = this.connFactory.createPersistentConnection();
            }
            catch (ConfigurationException e) {
                throw new ConfigurationConnectionException((Throwable)e);
            }
        }
        return this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearCache() {
        Object object = this.lock;
        synchronized (object) {
            this.configs.clear();
            this.transConfigs.clear();
        }
    }

    private void validateLock(ConfigTransaction transaction) throws ConfigurationLockException {
        if (transaction == null) {
            throw new ConfigurationLockException("ERR.014.002.0123", PlatformPlugin.Util.getString("ERR.014.002.0123"));
        }
        if (transaction.getTransactionLock() == null) {
            throw new ConfigurationLockException("ERR.014.002.0124", PlatformPlugin.Util.getString("ERR.014.002.0124"));
        }
    }

    protected ConfigurationChangeListener createChangeListener() {
        return new ConfigurationChangeListener(this);
    }

    protected class ConfigurationChangeListener
    implements EventObjectListener {
        private XMLConfigurationMgr mgr = null;

        public ConfigurationChangeListener(XMLConfigurationMgr theMgr) {
            this.mgr = theMgr;
        }

        public void processEvent(EventObject obj) {
            if (obj instanceof ConfigurationChangeEvent) {
                this.mgr.clearCache();
            }
        }
    }
}

