# Solaris 2.5.1 environment specific makefile header
#
# This file is automatically included in platform
# independent makefiles to abstract out features.


# **************************
# Define System dependencies
# **************************

# Define local file extensions
O=.o
A=.a
EXE=
SH=.sh

LIB_DIR=lib/$(PORTDEPS_DIR_NAME)
OBJ_DIR=obj/$(PORTDEPS_DIR_NAME)

#XM_TYPE=sh_xm
XM_TYPE=xm

# ************************************
# Define Project directories 
# ************************************

RDA_INC_DIR=$(OA_ROOT)/inc
RDA_LIB_DIR=$(OA_ROOT)/$(LIB_DIR)
RDA_BIN_DIR=$(OA_ROOT)/bin/$(PORTDEPS_DIR_NAME)
DAMIP_ROOT=$(OA_ROOT)/sdk/damip
RELEASEC_DIR=/usr/home/eworks/ReleaseC/rda

# Basic OpenRDA include path
OPENRDA_INC_PATH=-I$(RDA_INC_DIR) $(LOCAL_INC_PATH)

# ************************************
# Define command symbols
# ************************************
# C compiler command
CC=cc

# Linker command
LINKER=cc
LINKER_SHARED=ld

# library command
AR=ar

# ranlib command
RANLIB=ranlib

# strip command
STRIP=strip

# change directory command
CD=cd

# copy command
CP=cp

# remove command
RM=rm -f

# touch command
TOUCH=touch

# move command
MV=mv

# make command
MAKE=make

# change the file group attribute
CHGRP=chgrp

# change the rights
CHMOD=chmod

# echo something to the console
ECHO=echo

# command processor
SH_EXE=csh -f


SET_EXE_RIGHTS=$(CHMOD) 755
SET_EXE_GROUP=$(CHGRP) eworks
SET_LIC_RIGHTS=$(CHMOD) 644
SET_LIC_GROUP=$(CHGRP) eworks
SET_SRC_RIGHTS=$(CHMOD) 644
SET_SRC_GROUP=$(CHGRP) eworks
SET_DB_RIGHTS=$(CHMOD) 666
SET_DB_GROUP=$(CHGRP) eworks
SET_SDK_RIGHTS=$(CHMOD) 666
SET_SDK_GROUP=$(CHGRP) eworks

# ************************************
# Define Commands flags 
# ************************************
# Global environment-specific archive A flags
GAFLAGS=cruv

# Global environment-specific archive Y flags
GYFLAGS=-v -d

# Global compile flags
GCFLAGS=-DSunOS5 -O -DLINT_ARGS -D_REENTRANT $(NO_UNICODE_FLAGS) -xarch=v9 -DOA_OS64

# Global ANSI flag setting
GCFLAGS_ANSI=

# Global environment-specific linker L flags
GLFLAGS=-xarch=v9

# Global environment-specific linker L flags for shared library
GLFLAGS_SHARED=

# Global environment-specific shared library  L flags
GSFLAGS= -G -B symbolic 

# Global User-defined  DFLAGS
GDFLAGS=$(MAN_DFLAGS)

# Oracle libraries needed to build OpenRDA server
ORACLE_LIBS=

# System libraries
#GSYS_LIBS=$(RDA_LIB_DIR)/libshsun.a -lm -lsocket -lnsl -lpthread -lposix4 -lw
GSYS_LIBS= -lm -lsocket -lnsl -lpthread -lposix4 $(UNICODE_SYS_LIB) -ldl

#JDK_ROOT=/usr/dev/jdk1.2.2
#JDK_INC_PATH=-I$(JDK_ROOT)/include -I$(JDK_ROOT)/include/solaris -I$(ODBC_ROOT)/ include/port -I$(JDK_ROOT)/include-old -I$(JDK_ROOT)/include-old/solaris
#JDK_LIBS=
#JDK_LFLAGS=                                                            

REC_MAKE_BEG=($(CD)
REC_MAKE_MID=; $(MAKE)
REC_MAKE_END=)

FIND_FILES_ARG={} \;
