#!/bin/csh

######################################
#
# Setup .ODBC.INI
#
######################################

 oa_root="$inst_dir"
 oa_odbc_ini="$inst_dir/config/$oa_platform/odbc.ini"

if test $oa_copy_schema = "y" 
then
	rm -f $oa_odbc_ini
	touch $oa_odbc_ini

	echo "[ODBC Data Sources]" >> $oa_odbc_ini
	echo "$oa_server_name = OpenAccess"		>> $oa_odbc_ini
	echo ""		>> $oa_odbc_ini

	echo "[$oa_server_name]"		>> $oa_odbc_ini

	# HPUX 32 bit requires Driver name to be with .sl extension
    if test $PLATFORM = "phpux"
   	then
        if (test $OA_ARCHITECTURE = "_ia64")
	    then
			echo "Driver          = $oa_root/lib/$oa_platform/oaodbc.so" >> $oa_odbc_ini
		else
			echo "Driver          = $oa_root/lib/$oa_platform/oaodbc.sl" >> $oa_odbc_ini
		fi # Architecture specific 
	else
		echo "Driver          = $oa_root/lib/$oa_platform/oaodbc.so" >> $oa_odbc_ini
	fi
	echo "Description     = OpenAccess DSN" >> $oa_odbc_ini
	echo "" 				>> $oa_odbc_ini

	echo "[ODBC]" >> $oa_odbc_ini
	echo "IANAAppCodePage=4"		>> $oa_odbc_ini
	echo "InstallDir=$oa_root"		>> $oa_odbc_ini
	echo "Trace=0"					>> $oa_odbc_ini
	echo "TraceFile=$oa_root/bin/$oa_platform/odbctrac.out"		>> $oa_odbc_ini

	# HPUX 32 bit installs trace library with .sl extension
    if test $PLATFORM = "phpux"
   	then
        if (test $OA_ARCHITECTURE = "_ia64")
	    then
			echo "TraceDll=$oa_root/lib/$oa_platform/odbctrac.so"		>> $oa_odbc_ini
		else
			echo "TraceDll=$oa_root/lib/$oa_platform/odbctrac.sl"		>> $oa_odbc_ini
		fi # Architecture specific 
	else
		echo "TraceDll=$oa_root/lib/$oa_platform/odbctrac.so"		>> $oa_odbc_ini
	fi
	echo ""		>> $oa_odbc_ini

fi
