/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v2alpha1

import (
	"fmt"
	v2alpha1 "github.com/artemiscloud/activemq-artemis-operator/pkg/apis/broker/v2alpha1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// ActiveMQArtemisAddressLister helps list ActiveMQArtemisAddresses.
type ActiveMQArtemisAddressLister interface {
	// List lists all ActiveMQArtemisAddresses in the indexer.
	List(selector labels.Selector) (ret []*v2alpha1.ActiveMQArtemisAddress, err error)
	// ActiveMQArtemisAddresses returns an object that can list and get ActiveMQArtemisAddresses.
	ActiveMQArtemisAddresses(namespace string) ActiveMQArtemisAddressNamespaceLister
	ActiveMQArtemisAddressListerExpansion
}

// activeMQArtemisAddressLister implements the ActiveMQArtemisAddressLister interface.
type activeMQArtemisAddressLister struct {
	indexer cache.Indexer
}

// NewActiveMQArtemisAddressLister returns a new ActiveMQArtemisAddressLister.
func NewActiveMQArtemisAddressLister(indexer cache.Indexer) ActiveMQArtemisAddressLister {
	return &activeMQArtemisAddressLister{indexer: indexer}
}

// List lists all ActiveMQArtemisAddresses in the indexer.
func (s *activeMQArtemisAddressLister) List(selector labels.Selector) (ret []*v2alpha1.ActiveMQArtemisAddress, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v2alpha1.ActiveMQArtemisAddress))
	})
	return ret, err
}

// ActiveMQArtemisAddresses returns an object that can list and get ActiveMQArtemisAddresses.
func (s *activeMQArtemisAddressLister) ActiveMQArtemisAddresses(namespace string) ActiveMQArtemisAddressNamespaceLister {
	return activeMQArtemisAddressNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// ActiveMQArtemisAddressNamespaceLister helps list and get ActiveMQArtemisAddresses.
type ActiveMQArtemisAddressNamespaceLister interface {
	// List lists all ActiveMQArtemisAddresses in the indexer for a given namespace.
	List(selector labels.Selector) (ret []*v2alpha1.ActiveMQArtemisAddress, err error)
	// Get retrieves the ActiveMQArtemisAddress from the indexer for a given namespace and name.
	Get(name string) (*v2alpha1.ActiveMQArtemisAddress, error)
	ActiveMQArtemisAddressNamespaceListerExpansion
}

// activeMQArtemisAddressNamespaceLister implements the ActiveMQArtemisAddressNamespaceLister
// interface.
type activeMQArtemisAddressNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all ActiveMQArtemisAddresses in the indexer for a given namespace.
func (s activeMQArtemisAddressNamespaceLister) List(selector labels.Selector) (ret []*v2alpha1.ActiveMQArtemisAddress, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v2alpha1.ActiveMQArtemisAddress))
	})
	return ret, err
}

// Get retrieves the ActiveMQArtemisAddress from the indexer for a given namespace and name.
func (s activeMQArtemisAddressNamespaceLister) Get(name string) (*v2alpha1.ActiveMQArtemisAddress, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, fmt.Errorf("activemqartemisaddress not found: %s", name)
	}
	return obj.(*v2alpha1.ActiveMQArtemisAddress), nil
}
