  ------------------------------------------------------------------------------------
  Copyright (c) 2018 Red Hat, Inc.
  All rights reserved.
  
  Licensed under the Apache License, Version 2.0 (the ""License""); you may not use this
  file except in compliance with the License. You may obtain a copy of the License at
  http://www.apache.org/licenses/LICENSE-2.0
  
  THIS CODE IS PROVIDED *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
  EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED WARRANTIES OR
  CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE, MERCHANTABLITY OR
  NON-INFRINGEMENT.
  
  See the Apache Version 2.0 License for specific language governing permissions and
  limitations under the License.
  ------------------------------------------------------------------------------------

#AMQP.Net Lite Core SDK


1. Introduction
===
AMQ-dotnetcore SDK is a software development kit for users who wish
to communicate using AMQP 1.0 from *.NET* programs in a *Dotnet Core 2.0*
environment. AMQP protocol support is provided by pre-compiled
AMQP.Net Lite libraries.

This kit is distributed as a .zip file.

For additional software or information on the AMQP.Net Lite project see
[http://github.com/Azure/amqpnetlite](http://github.com/Azure/amqpnetlite)


2. Prerequisites
==
 - .NET Core 2.0 on Red Hat Enterprise Linux (RHEL) 7.
 - .OpenShift Container Platform versions 3.3 and later.

3. Kit contents
==
The kit directories hold the content described here.

  **\bin**  
    precompiled binary (.dll) files  
    debug program database (.pdb) files  
    documentation (.xml) files  
    .NET Core dependencies (.json) files

    Note that the files in __\bin__ are normally not required for using this SDK. These files are included for debugging and for project inclusion in larger packages.
    
  **\nupkg**  
    A NuGet package to be installed locally on the target system.

  **\examples**  
    Source files which demonstrate using this SDK and AMQP.  
    File examples\README.md describes the example programs.

  **\doc**  
    AMQP.Net Lite source documentation  
    See file \doc\html\index.html

3. *.NET Framework* version support
==

The pre-compiled NuGet package __amq-dotnet.2.1.6.nupkg__ is built targeting *.NETcore2.0*.


Each example in this kit targets *netcoreapp2.0* and includes a reference to package __amq-dotnet__ version __2.1.6__.


4. Install AMQ-dotnet NuGet package
==
Out of the box dotnet core 2.0 will search for packages only in the nuget.org package store. The library for AMQ-dotnet must be installed into a local package source. These instructions install the AMQ-dotnet NuGet package for a single user.

Activate a local package source
===

* Edit file ~/.nuget/NuGet/NuGet.Config
* Add line to configuration packageSources to create a package source in a local directory. In this example the 'local' package source is directory '/home/root/my-nupkgs'.

```xml

    <?xml version="1.0" encoding="utf-8"?>
    <configuration>
      <packageSources>
        <add key="local" value="/home/root/my-nupkgs" />
        <add key="nuget.org" value="https://api.nuget.org/v3/index.json" protocolVersion="3" />
      </packageSources>
    </configuration>
```

* Copy the AMQ-dotnet SDK NuGet file to the local package source directory.

    # install the nuget package locally
    cp <kit>/nuget/* /home/root/my-nupkgs

The AMQ-dotnet library is now available for use in the dotnet ecosystem.


5. Running examples
==

CD into one of the examples directories and run the program:

    # cd to an example
    cd examples/HelloWorld-robust

    # run the example
    dotnet run

