  ------------------------------------------------------------------------------------
  Copyright (c) 2016 Red Hat, Inc.
  All rights reserved.
  
  Licensed under the Apache License, Version 2.0 (the ""License""); you may not use this
  file except in compliance with the License. You may obtain a copy of the License at
  http://www.apache.org/licenses/LICENSE-2.0
  
  THIS CODE IS PROVIDED *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
  EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED WARRANTIES OR
  CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE, MERCHANTABLITY OR
  NON-INFRINGEMENT.
  
  See the Apache Version 2.0 License for specific language governing permissions and
  limitations under the License.
  ------------------------------------------------------------------------------------

#AMQP.Net Lite SDK


1. Introduction
===
AMQP.Net Lite SDK is a software development kit for users who wish
to communicate using AMQP 1.0 from *.NET* programs in a *Microsoft Windows*
environment. AMQP protocol support is provided by pre-compiled
AMQP.Net Lite libraries.

This kit is distributed as a .zip file.

For additional software or information on the AMQP.Net Lite project see
[http://github.com/Azure/amqpnetlite](http://github.com/Azure/amqpnetlite)


2. Prerequisites
==
 - Microsoft [Visual Studio 2012](https://msdn.microsoft.com/en-us/library/dd831853%28v=vs.110%29.aspx) or [Visual Studio 2013](https://msdn.microsoft.com/en-us/library/dd831853%28v=vs.120%29.aspx)
 - Microsoft [.NET Framework](https://www.microsoft.com/net/default.aspx) support for [Common Language Runtime (CLR)](https://msdn.microsoft.com/en-us/library/8bs2ecf4#Anchor_0) version 4.


3. Kit contents
==
The kit directories hold the content described here.

  **\bin**  
    precompiled binary (.dll) files  
    debug program database (.pdb) files  
    documentation (.xml) files

  **\examples**  
    Source files which demonstrate using this SDK and AMQP.  
    File examples\README.md describes the example programs.

  **\doc**  
    AMQP.Net Lite source documentation  
    See file \doc\html\index.html

4. *.NET Framework* version support
==

The pre-compiled library library __Amqp.Net.dll__ is built targeting
*.NET Framework* version 4.5.

Each example in this kit targets *.NET Framework* Version 4.5
and includes a reference to __Amqp.Net.dll__.

5. Building examples
==

Open one of the *Visual Studio* solution files:

    amqp.sln         Visual Studio 2013 (or later)
    amqp-vs2012.sln  Visual Studio 2012 (or later)
  
Compile and run the examples in Debug or Release configuration.

Alternatively, the example executable programs may be generated from a command prompt. For example, from the *Windows* start menu open **Developer Command Prompt for VS2012** and then execute:

    REM Build all the examples
    cd <kit install folder>
    devenv amqp-vs2012.sln /build "Debug|Any CPU"
    
    REM Run HelloWorld
    cd bin\Debug
    HelloWorld-simple.exe

## Credits

*Microsoft, Windows, .NET Framework, Common Language Runtime, and Visual Studio are either registered trademarks or trademarks of Microsoft Corporation in the United States and/or other countries.*
