REM
REM Licensed to the Apache Software Foundation (ASF) under one
REM or more contributor license agreements.  See the NOTICE file
REM distributed with this work for additional information
REM regarding copyright ownership.  The ASF licenses this file
REM to you under the Apache License, Version 2.0 (the
REM "License"); you may not use this file except in compliance
REM with the License.  You may obtain a copy of the License at
REM 
REM   http://www.apache.org/licenses/LICENSE-2.0
REM 
REM Unless required by applicable law or agreed to in writing,
REM software distributed under the License is distributed on an
REM "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
REM KIND, either express or implied.  See the License for the
REM specific language governing permissions and limitations
REM under the License.
REM
REM Build the AMQP.Net Lite SDK from source.
REM Execute this script from directory <git-checkout-root>.
REM
REM This script requires:
REM  * Visual Studio 2012 with x64 support
REM  * doxygen
REM  * 7zip

setlocal

REM Where VsDevCmd.bat is supposed to be when it exits
set "VSCMD_START_DIR=%CD%"

REM Root the builds in the R:\ drive so that none of the
REM build file hierarchy bleeds out in the PDB files.
set CURDRIVE=%~d0
subst /d R:
subst R: .
R:

REM wake up vs2017 msbuild
IF EXIST "c:\Program Files (x86)\Microsoft Visual Studio\2017\Professional\Common7\Tools\VsDevCmd.bat" (
    call "c:\Program Files (x86)\Microsoft Visual Studio\2017\Professional\Common7\Tools\VsDevCmd.bat"
) ELSE (
    call "N:\Program Files (x86)\Microsoft Visual Studio\2017\Professional\Common7\Tools\VsDevCmd.bat"
)
@echo on
 
 REM Recover current working directory
R:
CD
DIR
SUBST

REM compile
msbuild /nologo csproj\Amqp.Net.csproj /p:Configuration=Release;Platform="Any CPU";OutputPath=..\bin\Release;DefineConstants="DEBUG;TRACE;NETFX"
IF ERRORLEVEL 1 EXIT /b 1

msbuild /nologo csproj\Amqp.Net.csproj /p:Configuration=Debug;Platform="Any CPU";OutputPath=..\bin\Debug;DefineConstants="TRACE;NETFX"
IF ERRORLEVEL 1 EXIT /b 1

REM get rid of snk files dropped by msbuild
del *.snk

REM Restore normal build directory structure
%CURDRIVE%

REM Create install root
set INSTALL_FOLDER=amq-clients-%1-dotnet
mkdir %INSTALL_FOLDER%\bin
mkdir %INSTALL_FOLDER%\doc

REM Install the mission code
pushd bin
xcopy /s *.dll ..\%INSTALL_FOLDER%\bin
xcopy /s *.pdb ..\%INSTALL_FOLDER%\bin
xcopy /s *.xml ..\%INSTALL_FOLDER%\bin
popd

REM install files from SDK source, fix critical line endings
pushd SDK
unix2dos amqp.sln
unix2dos amqp-vs2013.sln
move amqpnetlite-doxygen-config.txt ..
xcopy /s * ..\%INSTALL_FOLDER%
popd

REM run doxygen; install result
doxygen amqpnetlite-doxygen-config.txt
if %errorlevel% neq 0 exit /b %errorlevel%
xcopy /s doxygen-html %INSTALL_FOLDER%\doc
IF ERRORLEVEL 1 EXIT /b 1

REM create shippable zip file
mkdir tmp
move %INSTALL_FOLDER% tmp
7z a %INSTALL_FOLDER%.zip .\tmp\*
IF ERRORLEVEL 1 EXIT /b 1

endlocal
