/*
 * Copyright 2018-2019, EnMasse authors.
 * License: Apache License 2.0 (see the file LICENSE or http://apache.org/licenses/LICENSE-2.0.html).
 */

// Code generated by client-gen. DO NOT EDIT.

package v1beta1

import (
	v1beta1 "github.com/enmasseproject/enmasse/pkg/apis/enmasse/v1beta1"
	"github.com/enmasseproject/enmasse/pkg/client/clientset/versioned/scheme"
	serializer "k8s.io/apimachinery/pkg/runtime/serializer"
	rest "k8s.io/client-go/rest"
)

type EnmasseV1beta1Interface interface {
	RESTClient() rest.Interface
	AddressesGetter
	AddressSpacesGetter
}

// EnmasseV1beta1Client is used to interact with features provided by the enmasse.io group.
type EnmasseV1beta1Client struct {
	restClient rest.Interface
}

func (c *EnmasseV1beta1Client) Addresses(namespace string) AddressInterface {
	return newAddresses(c, namespace)
}

func (c *EnmasseV1beta1Client) AddressSpaces(namespace string) AddressSpaceInterface {
	return newAddressSpaces(c, namespace)
}

// NewForConfig creates a new EnmasseV1beta1Client for the given config.
func NewForConfig(c *rest.Config) (*EnmasseV1beta1Client, error) {
	config := *c
	if err := setConfigDefaults(&config); err != nil {
		return nil, err
	}
	client, err := rest.RESTClientFor(&config)
	if err != nil {
		return nil, err
	}
	return &EnmasseV1beta1Client{client}, nil
}

// NewForConfigOrDie creates a new EnmasseV1beta1Client for the given config and
// panics if there is an error in the config.
func NewForConfigOrDie(c *rest.Config) *EnmasseV1beta1Client {
	client, err := NewForConfig(c)
	if err != nil {
		panic(err)
	}
	return client
}

// New creates a new EnmasseV1beta1Client for the given RESTClient.
func New(c rest.Interface) *EnmasseV1beta1Client {
	return &EnmasseV1beta1Client{c}
}

func setConfigDefaults(config *rest.Config) error {
	gv := v1beta1.SchemeGroupVersion
	config.GroupVersion = &gv
	config.APIPath = "/apis"
	config.NegotiatedSerializer = serializer.DirectCodecFactory{CodecFactory: scheme.Codecs}

	if config.UserAgent == "" {
		config.UserAgent = rest.DefaultKubernetesUserAgent()
	}

	return nil
}

// RESTClient returns a RESTClient that is used to communicate
// with API server by this client implementation.
func (c *EnmasseV1beta1Client) RESTClient() rest.Interface {
	if c == nil {
		return nil
	}
	return c.restClient
}
