/*
 * Copyright 2018-2019, EnMasse authors.
 * License: Apache License 2.0 (see the file LICENSE or http://apache.org/licenses/LICENSE-2.0.html).
 */

// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	v1alpha1 "github.com/enmasseproject/enmasse/pkg/apis/iot/v1alpha1"
	scheme "github.com/enmasseproject/enmasse/pkg/client/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// IoTProjectsGetter has a method to return a IoTProjectInterface.
// A group's client should implement this interface.
type IoTProjectsGetter interface {
	IoTProjects(namespace string) IoTProjectInterface
}

// IoTProjectInterface has methods to work with IoTProject resources.
type IoTProjectInterface interface {
	Create(*v1alpha1.IoTProject) (*v1alpha1.IoTProject, error)
	Update(*v1alpha1.IoTProject) (*v1alpha1.IoTProject, error)
	UpdateStatus(*v1alpha1.IoTProject) (*v1alpha1.IoTProject, error)
	Delete(name string, options *v1.DeleteOptions) error
	DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error
	Get(name string, options v1.GetOptions) (*v1alpha1.IoTProject, error)
	List(opts v1.ListOptions) (*v1alpha1.IoTProjectList, error)
	Watch(opts v1.ListOptions) (watch.Interface, error)
	Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1alpha1.IoTProject, err error)
	IoTProjectExpansion
}

// ioTProjects implements IoTProjectInterface
type ioTProjects struct {
	client rest.Interface
	ns     string
}

// newIoTProjects returns a IoTProjects
func newIoTProjects(c *IotV1alpha1Client, namespace string) *ioTProjects {
	return &ioTProjects{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the ioTProject, and returns the corresponding ioTProject object, and an error if there is any.
func (c *ioTProjects) Get(name string, options v1.GetOptions) (result *v1alpha1.IoTProject, err error) {
	result = &v1alpha1.IoTProject{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("iotprojects").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of IoTProjects that match those selectors.
func (c *ioTProjects) List(opts v1.ListOptions) (result *v1alpha1.IoTProjectList, err error) {
	result = &v1alpha1.IoTProjectList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("iotprojects").
		VersionedParams(&opts, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested ioTProjects.
func (c *ioTProjects) Watch(opts v1.ListOptions) (watch.Interface, error) {
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("iotprojects").
		VersionedParams(&opts, scheme.ParameterCodec).
		Watch()
}

// Create takes the representation of a ioTProject and creates it.  Returns the server's representation of the ioTProject, and an error, if there is any.
func (c *ioTProjects) Create(ioTProject *v1alpha1.IoTProject) (result *v1alpha1.IoTProject, err error) {
	result = &v1alpha1.IoTProject{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("iotprojects").
		Body(ioTProject).
		Do().
		Into(result)
	return
}

// Update takes the representation of a ioTProject and updates it. Returns the server's representation of the ioTProject, and an error, if there is any.
func (c *ioTProjects) Update(ioTProject *v1alpha1.IoTProject) (result *v1alpha1.IoTProject, err error) {
	result = &v1alpha1.IoTProject{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("iotprojects").
		Name(ioTProject.Name).
		Body(ioTProject).
		Do().
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().

func (c *ioTProjects) UpdateStatus(ioTProject *v1alpha1.IoTProject) (result *v1alpha1.IoTProject, err error) {
	result = &v1alpha1.IoTProject{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("iotprojects").
		Name(ioTProject.Name).
		SubResource("status").
		Body(ioTProject).
		Do().
		Into(result)
	return
}

// Delete takes name of the ioTProject and deletes it. Returns an error if one occurs.
func (c *ioTProjects) Delete(name string, options *v1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("iotprojects").
		Name(name).
		Body(options).
		Do().
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *ioTProjects) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("iotprojects").
		VersionedParams(&listOptions, scheme.ParameterCodec).
		Body(options).
		Do().
		Error()
}

// Patch applies the patch and returns the patched ioTProject.
func (c *ioTProjects) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1alpha1.IoTProject, err error) {
	result = &v1alpha1.IoTProject{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("iotprojects").
		SubResource(subresources...).
		Name(name).
		Body(data).
		Do().
		Into(result)
	return
}
