/*
 * Copyright 2018-2019, EnMasse authors.
 * License: Apache License 2.0 (see the file LICENSE or http://apache.org/licenses/LICENSE-2.0.html).
 */

// Code generated by informer-gen. DO NOT EDIT.

package v1beta2

import (
	time "time"

	adminv1beta2 "github.com/enmasseproject/enmasse/pkg/apis/admin/v1beta2"
	versioned "github.com/enmasseproject/enmasse/pkg/client/clientset/versioned"
	internalinterfaces "github.com/enmasseproject/enmasse/pkg/client/informers/externalversions/internalinterfaces"
	v1beta2 "github.com/enmasseproject/enmasse/pkg/client/listers/admin/v1beta2"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	runtime "k8s.io/apimachinery/pkg/runtime"
	watch "k8s.io/apimachinery/pkg/watch"
	cache "k8s.io/client-go/tools/cache"
)

// AddressSpacePlanInformer provides access to a shared informer and lister for
// AddressSpacePlans.
type AddressSpacePlanInformer interface {
	Informer() cache.SharedIndexInformer
	Lister() v1beta2.AddressSpacePlanLister
}

type addressSpacePlanInformer struct {
	factory          internalinterfaces.SharedInformerFactory
	tweakListOptions internalinterfaces.TweakListOptionsFunc
	namespace        string
}

// NewAddressSpacePlanInformer constructs a new informer for AddressSpacePlan type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewAddressSpacePlanInformer(client versioned.Interface, namespace string, resyncPeriod time.Duration, indexers cache.Indexers) cache.SharedIndexInformer {
	return NewFilteredAddressSpacePlanInformer(client, namespace, resyncPeriod, indexers, nil)
}

// NewFilteredAddressSpacePlanInformer constructs a new informer for AddressSpacePlan type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewFilteredAddressSpacePlanInformer(client versioned.Interface, namespace string, resyncPeriod time.Duration, indexers cache.Indexers, tweakListOptions internalinterfaces.TweakListOptionsFunc) cache.SharedIndexInformer {
	return cache.NewSharedIndexInformer(
		&cache.ListWatch{
			ListFunc: func(options v1.ListOptions) (runtime.Object, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.AdminV1beta2().AddressSpacePlans(namespace).List(options)
			},
			WatchFunc: func(options v1.ListOptions) (watch.Interface, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.AdminV1beta2().AddressSpacePlans(namespace).Watch(options)
			},
		},
		&adminv1beta2.AddressSpacePlan{},
		resyncPeriod,
		indexers,
	)
}

func (f *addressSpacePlanInformer) defaultInformer(client versioned.Interface, resyncPeriod time.Duration) cache.SharedIndexInformer {
	return NewFilteredAddressSpacePlanInformer(client, f.namespace, resyncPeriod, cache.Indexers{cache.NamespaceIndex: cache.MetaNamespaceIndexFunc}, f.tweakListOptions)
}

func (f *addressSpacePlanInformer) Informer() cache.SharedIndexInformer {
	return f.factory.InformerFor(&adminv1beta2.AddressSpacePlan{}, f.defaultInformer)
}

func (f *addressSpacePlanInformer) Lister() v1beta2.AddressSpacePlanLister {
	return v1beta2.NewAddressSpacePlanLister(f.Informer().GetIndexer())
}
