/*
 * Copyright 2018-2019, EnMasse authors.
 * License: Apache License 2.0 (see the file LICENSE or http://apache.org/licenses/LICENSE-2.0.html).
 */

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	v1beta2 "github.com/enmasseproject/enmasse/pkg/apis/admin/v1beta2"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeAddressPlans implements AddressPlanInterface
type FakeAddressPlans struct {
	Fake *FakeAdminV1beta2
	ns   string
}

var addressplansResource = schema.GroupVersionResource{Group: "admin.enmasse.io", Version: "v1beta2", Resource: "addressplans"}

var addressplansKind = schema.GroupVersionKind{Group: "admin.enmasse.io", Version: "v1beta2", Kind: "AddressPlan"}

// Get takes name of the addressPlan, and returns the corresponding addressPlan object, and an error if there is any.
func (c *FakeAddressPlans) Get(name string, options v1.GetOptions) (result *v1beta2.AddressPlan, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(addressplansResource, c.ns, name), &v1beta2.AddressPlan{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta2.AddressPlan), err
}

// List takes label and field selectors, and returns the list of AddressPlans that match those selectors.
func (c *FakeAddressPlans) List(opts v1.ListOptions) (result *v1beta2.AddressPlanList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(addressplansResource, addressplansKind, c.ns, opts), &v1beta2.AddressPlanList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1beta2.AddressPlanList{ListMeta: obj.(*v1beta2.AddressPlanList).ListMeta}
	for _, item := range obj.(*v1beta2.AddressPlanList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested addressPlans.
func (c *FakeAddressPlans) Watch(opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(addressplansResource, c.ns, opts))

}

// Create takes the representation of a addressPlan and creates it.  Returns the server's representation of the addressPlan, and an error, if there is any.
func (c *FakeAddressPlans) Create(addressPlan *v1beta2.AddressPlan) (result *v1beta2.AddressPlan, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(addressplansResource, c.ns, addressPlan), &v1beta2.AddressPlan{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta2.AddressPlan), err
}

// Update takes the representation of a addressPlan and updates it. Returns the server's representation of the addressPlan, and an error, if there is any.
func (c *FakeAddressPlans) Update(addressPlan *v1beta2.AddressPlan) (result *v1beta2.AddressPlan, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(addressplansResource, c.ns, addressPlan), &v1beta2.AddressPlan{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta2.AddressPlan), err
}

// Delete takes name of the addressPlan and deletes it. Returns an error if one occurs.
func (c *FakeAddressPlans) Delete(name string, options *v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteAction(addressplansResource, c.ns, name), &v1beta2.AddressPlan{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeAddressPlans) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(addressplansResource, c.ns, listOptions)

	_, err := c.Fake.Invokes(action, &v1beta2.AddressPlanList{})
	return err
}

// Patch applies the patch and returns the patched addressPlan.
func (c *FakeAddressPlans) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1beta2.AddressPlan, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(addressplansResource, c.ns, name, data, subresources...), &v1beta2.AddressPlan{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta2.AddressPlan), err
}
