/*
 * Copyright 2018-2019, EnMasse authors.
 * License: Apache License 2.0 (see the file LICENSE or http://apache.org/licenses/LICENSE-2.0.html).
 */

// Code generated by lister-gen. DO NOT EDIT.

package v1alpha1

import (
	v1alpha1 "github.com/enmasseproject/enmasse/pkg/apis/iot/v1alpha1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// IoTProjectLister helps list IoTProjects.
type IoTProjectLister interface {
	// List lists all IoTProjects in the indexer.
	List(selector labels.Selector) (ret []*v1alpha1.IoTProject, err error)
	// IoTProjects returns an object that can list and get IoTProjects.
	IoTProjects(namespace string) IoTProjectNamespaceLister
	IoTProjectListerExpansion
}

// ioTProjectLister implements the IoTProjectLister interface.
type ioTProjectLister struct {
	indexer cache.Indexer
}

// NewIoTProjectLister returns a new IoTProjectLister.
func NewIoTProjectLister(indexer cache.Indexer) IoTProjectLister {
	return &ioTProjectLister{indexer: indexer}
}

// List lists all IoTProjects in the indexer.
func (s *ioTProjectLister) List(selector labels.Selector) (ret []*v1alpha1.IoTProject, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha1.IoTProject))
	})
	return ret, err
}

// IoTProjects returns an object that can list and get IoTProjects.
func (s *ioTProjectLister) IoTProjects(namespace string) IoTProjectNamespaceLister {
	return ioTProjectNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// IoTProjectNamespaceLister helps list and get IoTProjects.
type IoTProjectNamespaceLister interface {
	// List lists all IoTProjects in the indexer for a given namespace.
	List(selector labels.Selector) (ret []*v1alpha1.IoTProject, err error)
	// Get retrieves the IoTProject from the indexer for a given namespace and name.
	Get(name string) (*v1alpha1.IoTProject, error)
	IoTProjectNamespaceListerExpansion
}

// ioTProjectNamespaceLister implements the IoTProjectNamespaceLister
// interface.
type ioTProjectNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all IoTProjects in the indexer for a given namespace.
func (s ioTProjectNamespaceLister) List(selector labels.Selector) (ret []*v1alpha1.IoTProject, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha1.IoTProject))
	})
	return ret, err
}

// Get retrieves the IoTProject from the indexer for a given namespace and name.
func (s ioTProjectNamespaceLister) Get(name string) (*v1alpha1.IoTProject, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1alpha1.Resource("iotproject"), name)
	}
	return obj.(*v1alpha1.IoTProject), nil
}
