/*
 * Copyright Strimzi authors.
 * License: Apache License 2.0 (see the file LICENSE or http://apache.org/licenses/LICENSE-2.0.html).
 */
package io.strimzi.api.kafka.model.connect.build;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.strimzi.api.kafka.model.Constants;
import io.strimzi.crdgenerator.annotations.Description;
import io.sundr.builder.annotations.Buildable;
import lombok.EqualsAndHashCode;

/**
 * TGZ artifact represents an artifact which is downloaded and unpacked using TAR (with GZIP decompression)
 */
@Buildable(
        editableEnabled = false,
        builderPackage = Constants.FABRIC8_KUBERNETES_API
)
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({ "url", "sha512sum" })
@EqualsAndHashCode
public class TgzArtifact extends DownloadableArtifact {
    private static final long serialVersionUID = 1L;

    @Description("Must be `" + TYPE_TGZ + "`")
    @Override
    public String getType() {
        return TYPE_TGZ;
    }
}
