/*
 * Decompiled with CFR 0.152.
 */
package org.drools.concurrent;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.drools.WorkingMemory;
import org.drools.concurrent.Command;
import org.drools.concurrent.Future;

public class CommandExecutor
implements Runnable,
Externalizable {
    private static final long serialVersionUID = 5924295088331461167L;
    private WorkingMemory workingMemory;
    private BlockingQueue queue;
    private volatile boolean run;

    public CommandExecutor() {
    }

    public CommandExecutor(WorkingMemory workingMemory) {
        this.workingMemory = workingMemory;
        this.queue = new LinkedBlockingQueue();
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.workingMemory = (WorkingMemory)in.readObject();
        this.queue = (BlockingQueue)in.readObject();
        this.run = in.readBoolean();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.workingMemory);
        out.writeObject(this.queue);
        out.writeBoolean(this.run);
    }

    public void shutdown() {
        this.run = false;
    }

    public Future submit(Command command) {
        this.queue.offer(command);
        return (Future)((Object)command);
    }

    public void run() {
        this.run = true;
        while (this.run) {
            try {
                Command executor = (Command)this.queue.take();
                executor.execute(this.workingMemory);
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }
}

