/*
 * Decompiled with CFR 0.152.
 */
package org.drools.factmodel;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.base.ClassFieldAccessor;
import org.drools.definition.type.FactField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldDefinition
implements FactField {
    private String name = null;
    private String type = null;
    private boolean key = false;
    private ClassFieldAccessor accessor = null;

    public FieldDefinition() {
    }

    public FieldDefinition(String name, String type) {
        this(name, type, false);
    }

    public FieldDefinition(String name, String type, boolean key) {
        this.name = name;
        this.type = type;
        this.key = key;
    }

    public void setReadWriteAccessor(ClassFieldAccessor accessor) {
        this.accessor = accessor;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.name = (String)in.readObject();
        this.type = (String)in.readObject();
        this.key = in.readBoolean();
        this.accessor = (ClassFieldAccessor)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.name);
        out.writeObject(this.type);
        out.writeBoolean(this.key);
        out.writeObject(this.accessor);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTypeName() {
        return this.type;
    }

    public void setTypeName(String type) {
        this.type = type;
    }

    public Class<?> getType() {
        return this.accessor.getFieldType();
    }

    public boolean isKey() {
        return this.key;
    }

    public void setKey(boolean key) {
        this.key = key;
    }

    public String getReadMethod() {
        String prefix = null;
        prefix = "boolean".equals(this.type) ? "is" : "get";
        return prefix + this.name.substring(0, 1).toUpperCase() + this.name.substring(1);
    }

    public String getWriteMethod() {
        return "set" + this.name.substring(0, 1).toUpperCase() + this.name.substring(1);
    }

    public boolean equals(Object o) {
        return this.getName().equals(((FieldDefinition)o).getName());
    }

    public ClassFieldAccessor getFieldAccessor() {
        return this.accessor;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public void setValue(Object bean, Object value) {
        this.accessor.setValue(bean, value);
    }

    public Object getValue(Object bean) {
        return this.accessor.getValue(bean);
    }

    public Object get(Object bean) {
        return this.accessor.getValue(bean);
    }

    public void set(Object bean, Object value) {
        this.accessor.setValue(bean, value);
    }
}

