/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.proxool;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.logicalcobwebs.proxool.ConnectionPool;
import org.logicalcobwebs.proxool.ConnectionPoolManager;
import org.logicalcobwebs.proxool.Prototyper;
import org.logicalcobwebs.proxool.PrototyperController;

public class PrototyperThread
extends Thread {
    private static final ThreadGroup PROTOTYPER_THREAD_GROUP = new ThreadGroup("PROTOTYPER_THREAD_GROUP");
    private static final Log LOG = LogFactory.getLog(PrototyperThread.class);
    private boolean stop;

    public PrototyperThread(String name) {
        super(PROTOTYPER_THREAD_GROUP, name);
        this.setDaemon(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.stop) {
            int sweptCount = 0;
            while (PrototyperController.isKeepSweeping() && !this.stop) {
                PrototyperController.sweepStarted();
                ConnectionPool[] cps = ConnectionPoolManager.getInstance().getConnectionPools();
                for (int i = 0; i < cps.length && !this.stop; ++i) {
                    Prototyper p = cps[i].getPrototyper();
                    try {
                        cps[i].acquirePrimaryReadLock();
                        if (!cps[i].isConnectionPoolUp() || !p.isSweepNeeded()) continue;
                        p.sweep();
                        ++sweptCount;
                        continue;
                    }
                    catch (InterruptedException e) {
                        LOG.error((Object)"Couldn't acquire primary read lock", (Throwable)e);
                        continue;
                    }
                    finally {
                        cps[i].releasePrimaryReadLock();
                    }
                }
            }
            this.doWait();
        }
    }

    protected void cancel() {
        this.stop = true;
        this.doNotify();
    }

    private synchronized void doWait() {
        try {
            this.wait();
        }
        catch (InterruptedException e) {
            LOG.debug((Object)"Expected interruption of sleep");
        }
    }

    protected synchronized void doNotify() {
        this.notifyAll();
    }
}

