/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import org.jgroups.stack.GossipRouter;
import org.jgroups.util.Util;

public class MergeTest
extends TestCase {
    JChannel channel;
    static final int TIMES = 10;
    static final int router_port = 12001;
    static final String bind_addr = "127.0.0.1";
    GossipRouter router;
    JChannel ch1;
    JChannel ch2;
    private ViewChecker checker1;
    private ViewChecker checker2;
    private static final int NUM_MCASTS = 5;
    private static final int NUM_UCASTS = 10;
    private static final long WAIT_TIME = 2000L;
    String props = "tunnel.xml";

    public MergeTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.startRouter();
        this.ch1 = new JChannel(this.props);
        this.checker1 = new ViewChecker(this.ch1);
        this.ch1.setReceiver(this.checker1);
        this.ch1.connect("demo");
        this.ch2 = new JChannel(this.props);
        this.checker2 = new ViewChecker(this.ch2);
        this.ch2.setReceiver(this.checker2);
        this.ch2.connect("demo");
        Util.sleep(1000L);
    }

    public void tearDown() throws Exception {
        super.tearDown();
        this.ch2.close();
        this.ch1.close();
        this.stopRouter();
    }

    public void testPartitionAndSubsequentMerge() throws Exception {
        this.partitionAndMerge();
    }

    public void testTwoMerges() throws Exception {
        this.partitionAndMerge();
        this.partitionAndMerge();
    }

    private void partitionAndMerge() throws Exception {
        View v = this.ch2.getView();
        System.out.println("view is " + v);
        MergeTest.assertEquals((String)"channel is supposed to have 2 members", (int)2, (int)this.ch2.getView().size());
        System.out.println("sending 5 multicast messages");
        for (int i = 0; i < 5; ++i) {
            Message msg = new Message();
            this.ch1.send(msg);
        }
        System.out.println("sending 10 unicast messages to " + v.size() + " members");
        Vector<Address> mbrs = v.getMembers();
        for (Address mbr : mbrs) {
            for (int i = 0; i < 10; ++i) {
                JChannel ch = i % 2 == 0 ? this.ch1 : this.ch2;
                ((Channel)ch).send(new Message(mbr));
            }
        }
        System.out.println("done, sleeping for 2000 time");
        Util.sleep(2000L);
        System.out.println("++ simulating network partition by stopping the GossipRouter");
        this.stopRouter();
        System.out.println("sleeping for 10 secs");
        this.checker1.waitForNViews(1, 10000L);
        this.checker2.waitForNViews(1, 10000L);
        v = this.ch1.getView();
        System.out.println("-- ch1.view: " + v);
        v = this.ch2.getView();
        System.out.println("-- ch2.view: " + v);
        MergeTest.assertEquals((String)("view should be 1 (channels should have excluded each other): " + v), (int)1, (int)v.size());
        System.out.println("++ simulating merge by starting the GossipRouter again");
        this.startRouter();
        System.out.println("sleeping for 30 secs");
        this.checker1.waitForNViews(1, 30000L);
        this.checker2.waitForNViews(1, 30000L);
        v = this.ch1.getView();
        System.out.println("-- ch1.view: " + v);
        v = this.ch2.getView();
        System.out.println("-- ch2.view: " + v);
        MergeTest.assertEquals((String)"channel is supposed to have 2 members again after merge", (int)2, (int)this.ch2.getView().size());
    }

    private void startRouter() throws Exception {
        this.router = new GossipRouter(12001, bind_addr);
        this.router.start();
    }

    private void stopRouter() {
        this.router.stop();
    }

    public static void main(String[] args) {
        String[] testCaseName = new String[]{MergeTest.class.getName()};
        TestRunner.main((String[])testCaseName);
    }

    private static class ViewChecker
    extends ReceiverAdapter {
        final Object mutex = new Object();
        int count = 0;
        final Channel channel;
        final List<View> views = new LinkedList<View>();

        public ViewChecker(Channel channel) {
            this.channel = channel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void viewAccepted(View new_view) {
            Object object = this.mutex;
            synchronized (object) {
                ++this.count;
                View view = this.channel != null ? this.channel.getView() : null;
                this.views.add(view);
                this.mutex.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForNViews(int n, long timeout) {
            long sleep_time = timeout;
            Object object = this.mutex;
            synchronized (object) {
                this.views.clear();
                this.count = 0;
                long start = System.currentTimeMillis();
                while (this.count < n) {
                    long curr;
                    try {
                        this.mutex.wait(sleep_time);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    if ((sleep_time -= (curr = System.currentTimeMillis()) - start) > 0L) continue;
                }
            }
        }

        public void receive(Message msg) {
            Address sender = msg.getSrc();
            Address receiver = msg.getDest();
            boolean multicast = receiver == null || receiver.isMulticastAddress();
            System.out.println("[" + receiver + "]: received " + (multicast ? " multicast " : " unicast ") + " message from " + sender);
        }
    }
}

