/*
 * Decompiled with CFR 0.152.
 */
package org.milyn;

import org.milyn.Smooks;
import org.milyn.StreamFilterType;
import org.milyn.cdr.ParameterAccessor;

public class FilterSettings {
    public static final FilterSettings DEFAULT_DOM = new FilterSettings(StreamFilterType.DOM);
    public static final FilterSettings DEFAULT_SAX = new FilterSettings(StreamFilterType.SAX);
    private StreamFilterType filterType = StreamFilterType.DOM;
    private boolean rewriteEntities = true;
    private boolean defaultSerializationOn = true;
    private boolean terminateOnException = true;
    private boolean maintainElementStack = true;
    private boolean closeSource = true;
    private boolean closeResult = true;
    private int readerPoolSize = 0;

    public FilterSettings() {
    }

    public static FilterSettings newDOMSettings() {
        return new FilterSettings(StreamFilterType.DOM);
    }

    public static FilterSettings newSAXSettings() {
        return new FilterSettings(StreamFilterType.SAX);
    }

    public FilterSettings(StreamFilterType filterType) {
        this.assertNonStaticDecl();
        this.filterType = filterType;
    }

    public FilterSettings setFilterType(StreamFilterType filterType) {
        this.assertNonStaticDecl();
        this.filterType = filterType;
        return this;
    }

    public FilterSettings setRewriteEntities(boolean rewriteEntities) {
        this.assertNonStaticDecl();
        this.rewriteEntities = rewriteEntities;
        return this;
    }

    public FilterSettings setDefaultSerializationOn(boolean defaultSerializationOn) {
        this.assertNonStaticDecl();
        this.defaultSerializationOn = defaultSerializationOn;
        return this;
    }

    public FilterSettings setTerminateOnException(boolean terminateOnException) {
        this.assertNonStaticDecl();
        this.terminateOnException = terminateOnException;
        return this;
    }

    public FilterSettings setMaintainElementStack(boolean maintainElementStack) {
        this.assertNonStaticDecl();
        this.maintainElementStack = maintainElementStack;
        return this;
    }

    public FilterSettings setCloseSource(boolean closeSource) {
        this.assertNonStaticDecl();
        this.closeSource = closeSource;
        return this;
    }

    public FilterSettings setCloseResult(boolean closeResult) {
        this.assertNonStaticDecl();
        this.closeResult = closeResult;
        return this;
    }

    public FilterSettings setReaderPoolSize(int readerPoolSize) {
        this.assertNonStaticDecl();
        this.readerPoolSize = readerPoolSize;
        return this;
    }

    protected void applySettings(Smooks smooks) {
        ParameterAccessor.setParameter("stream.filter.type", this.filterType.toString(), smooks);
        ParameterAccessor.setParameter("entities.rewrite", Boolean.toString(this.rewriteEntities), smooks);
        ParameterAccessor.setParameter("default.serialization.on", Boolean.toString(this.defaultSerializationOn), smooks);
        ParameterAccessor.setParameter("terminate.on.visitor.exception", Boolean.toString(this.terminateOnException), smooks);
        ParameterAccessor.setParameter("maintain.element.stack", Boolean.toString(this.maintainElementStack), smooks);
        ParameterAccessor.setParameter("close.source", Boolean.toString(this.closeSource), smooks);
        ParameterAccessor.setParameter("close.result", Boolean.toString(this.closeResult), smooks);
        ParameterAccessor.setParameter("reader.pool.size", Integer.toString(this.readerPoolSize), smooks);
    }

    private void assertNonStaticDecl() {
        if (this == DEFAULT_DOM || this == DEFAULT_SAX) {
            throw new UnsupportedOperationException("Invalid attempt to modify static filter type declaration.");
        }
    }
}

