/*
 * Decompiled with CFR 0.152.
 */
package org.milyn;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.milyn.FilterSettings;
import org.milyn.ReaderConfigurator;
import org.milyn.SmooksException;
import org.milyn.assertion.AssertArgument;
import org.milyn.cdr.SmooksResourceConfiguration;
import org.milyn.container.ApplicationContext;
import org.milyn.container.ExecutionContext;
import org.milyn.container.standalone.StandaloneApplicationContext;
import org.milyn.container.standalone.StandaloneExecutionContext;
import org.milyn.delivery.ContentDeliveryConfig;
import org.milyn.delivery.Filter;
import org.milyn.delivery.FilterBypass;
import org.milyn.delivery.Visitor;
import org.milyn.delivery.VisitorAppender;
import org.milyn.delivery.VisitorConfigMap;
import org.milyn.event.ExecutionEventListener;
import org.milyn.event.types.FilterLifecycleEvent;
import org.milyn.net.URIUtil;
import org.milyn.payload.FilterResult;
import org.milyn.payload.FilterSource;
import org.milyn.profile.Profile;
import org.milyn.profile.UnknownProfileMemberException;
import org.milyn.resource.URIResourceLocator;
import org.xml.sax.SAXException;

public class Smooks {
    private static Log logger = LogFactory.getLog(Smooks.class);
    private StandaloneApplicationContext context = new StandaloneApplicationContext();
    private ClassLoader classLoader;
    private VisitorConfigMap visitorConfigMap = new VisitorConfigMap(this.context);
    private volatile boolean isConfigurable = true;

    public Smooks() {
    }

    public Smooks(String resourceURI) throws IOException, SAXException {
        this();
        this.addConfigurations(resourceURI);
    }

    public Smooks(InputStream resourceConfigStream) throws IOException, SAXException {
        this();
        this.addConfigurations(resourceConfigStream);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setFilterSettings(FilterSettings filterSettings) {
        AssertArgument.isNotNull(filterSettings, "filterSettings");
        filterSettings.applySettings(this);
    }

    public void setReaderConfig(ReaderConfigurator readerConfigurator) {
        SmooksResourceConfiguration readerConfig = readerConfigurator.toConfig();
        readerConfig.setSelector("org.xml.sax.driver");
        this.addConfiguration(readerConfig);
    }

    public SmooksResourceConfiguration addVisitor(Visitor visitor) {
        return this.addVisitor(visitor, "#document", null);
    }

    public SmooksResourceConfiguration addVisitor(Visitor visitor, String targetSelector) {
        return this.addVisitor(visitor, targetSelector, null);
    }

    public SmooksResourceConfiguration addVisitor(Visitor visitor, String targetSelector, String targetSelectorNS) {
        this.assertIsConfigurable();
        return this.visitorConfigMap.addVisitor(visitor, targetSelector, targetSelectorNS, true);
    }

    public void addVisitor(VisitorAppender appender) {
        appender.addVisitors(this.visitorConfigMap);
    }

    public void addConfiguration(SmooksResourceConfiguration resourceConfig) {
        AssertArgument.isNotNull(resourceConfig, "resourceConfig");
        this.assertIsConfigurable();
        this.context.getStore().registerResource(resourceConfig);
    }

    public void addConfigurations(String resourceURI) throws IOException, SAXException {
        AssertArgument.isNotNullAndNotEmpty(resourceURI, "resourceURI");
        URIResourceLocator resourceLocator = new URIResourceLocator();
        InputStream resourceConfigStream = resourceLocator.getResource(resourceURI);
        try {
            try {
                URI resourceURIObj = new URI(resourceURI);
                this.addConfigurations(URIUtil.getParent(resourceURIObj).toString(), resourceConfigStream);
            }
            catch (URISyntaxException e) {
                logger.error((Object)("Failed to load Smooks resource configuration '" + resourceURI + "'."), (Throwable)e);
                resourceConfigStream.close();
            }
        }
        finally {
            resourceConfigStream.close();
        }
    }

    public void addConfigurations(String baseURI, InputStream resourceConfigStream) throws SAXException, IOException {
        this.assertIsConfigurable();
        AssertArgument.isNotNullAndNotEmpty(baseURI, "baseURI");
        AssertArgument.isNotNull(resourceConfigStream, "resourceConfigStream");
        try {
            this.context.getStore().registerResources(baseURI, resourceConfigStream);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IOException("Failed to read resource configuration. Invalid 'baseURI'.");
        }
    }

    public void addConfigurations(InputStream resourceConfigStream) throws SAXException, IOException {
        this.addConfigurations("./", resourceConfigStream);
    }

    public ExecutionContext createExecutionContext() {
        return this.createExecutionContext(Profile.DEFAULT_PROFILE);
    }

    public ExecutionContext createExecutionContext(String targetProfile) throws UnknownProfileMemberException {
        this.isConfigurable = false;
        if (this.classLoader != null) {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.classLoader);
            try {
                StandaloneExecutionContext standaloneExecutionContext = new StandaloneExecutionContext(targetProfile, this.context, this.visitorConfigMap);
                return standaloneExecutionContext;
            }
            finally {
                Thread.currentThread().setContextClassLoader(contextClassLoader);
            }
        }
        return new StandaloneExecutionContext(targetProfile, this.context, this.visitorConfigMap);
    }

    public void filter(Source source) throws SmooksException {
        this.filterSource(this.createExecutionContext(), source, null);
    }

    public void filter(Source source, Result result) throws SmooksException {
        this.filterSource(this.createExecutionContext(), source, result);
    }

    public void filter(Source source, Result result, ExecutionContext executionContext) throws SmooksException {
        this.filterSource(executionContext, source, result);
    }

    public void filterSource(Source source) throws SmooksException {
        this.filterSource(this.createExecutionContext(), source, null);
    }

    public void filterSource(Source source, Result ... results) throws SmooksException {
        this.filterSource(this.createExecutionContext(), source, results);
    }

    public void filterSource(ExecutionContext executionContext, Source source, Result ... results) throws SmooksException {
        AssertArgument.isNotNull(source, "source");
        AssertArgument.isNotNull(executionContext, "executionContext");
        if (this.classLoader != null) {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.classLoader);
            try {
                this._filter(executionContext, source, results);
            }
            finally {
                Thread.currentThread().setContextClassLoader(contextClassLoader);
            }
        } else {
            this._filter(executionContext, source, results);
        }
    }

    private void _filter(ExecutionContext executionContext, Source source, Result ... results) {
        ExecutionEventListener eventListener = executionContext.getEventListener();
        try {
            Filter.setCurrentExecutionContext(executionContext);
            try {
                FilterBypass filterBypass;
                if (eventListener != null) {
                    eventListener.onEvent(new FilterLifecycleEvent(FilterLifecycleEvent.EventType.STARTED));
                }
                ContentDeliveryConfig deliveryConfig = executionContext.getDeliveryConfig();
                if (results != null && results.length == 1 && results[0] != null && (filterBypass = deliveryConfig.getFilterBypass()) != null && filterBypass.bypass(executionContext, source, results[0])) {
                    return;
                }
                Filter messageFilter = deliveryConfig.newFilter(executionContext);
                Filter.setFilter(messageFilter);
                try {
                    try {
                        FilterSource.setSource(executionContext, source);
                        FilterResult.setResults(executionContext, results);
                        messageFilter.doFilter();
                    }
                    catch (SmooksException e) {
                        executionContext.setTerminationError(e);
                        throw e;
                    }
                    catch (Throwable t) {
                        executionContext.setTerminationError(t);
                        throw new SmooksException("Smooks Filtering operation failed.", t);
                    }
                }
                finally {
                    messageFilter.cleanup();
                    Filter.removeCurrentFilter();
                }
            }
            finally {
                Filter.removeCurrentExecutionContext();
            }
        }
        finally {
            if (eventListener != null) {
                eventListener.onEvent(new FilterLifecycleEvent(FilterLifecycleEvent.EventType.FINISHED));
            }
        }
    }

    public ApplicationContext getApplicationContext() {
        return this.context;
    }

    public void close() {
        this.context.getStore().close();
    }

    private void assertIsConfigurable() {
        if (!this.isConfigurable) {
            throw new UnsupportedOperationException("Unsupported call to Smooks instance configuration method after Smooks instance has created an ExecutionContext.");
        }
    }
}

