/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.delivery.dom;

import java.util.HashSet;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.milyn.cdr.ParameterAccessor;
import org.milyn.container.ExecutionContext;
import org.milyn.dtd.DTDStore;
import org.milyn.xml.DocType;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DefaultHandler2;

public class DOMBuilder
extends DefaultHandler2 {
    private static Log logger = LogFactory.getLog(DOMBuilder.class);
    private static DocumentBuilder documentBuilder;
    private ExecutionContext execContext;
    private Document ownerDocument;
    private Stack nodeStack = new Stack();
    private boolean inEntity = false;
    private HashSet emptyElements = new HashSet();
    private StringBuilder cdataNodeBuilder = new StringBuilder();
    private boolean rewriteEntities = true;

    static {
        try {
            documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            IllegalStateException state = new IllegalStateException("XML DOM Parsing environment not configured properly.");
            state.initCause(e);
            throw state;
        }
    }

    public DOMBuilder(ExecutionContext execContext) {
        this.execContext = execContext;
        this.initialiseEmptyElements();
        this.rewriteEntities = ParameterAccessor.getBoolParameter("entities.rewrite", true, execContext.getDeliveryConfig());
    }

    private void initialiseEmptyElements() {
        String[] emptyEls;
        DTDStore.DTDObjectContainer dtd = this.execContext.getDeliveryConfig().getDTD();
        if (dtd != null && (emptyEls = dtd.getEmptyElements()) != null && emptyEls.length > 0) {
            int i = 0;
            while (i < emptyEls.length) {
                this.emptyElements.add(emptyEls[i]);
                ++i;
            }
        }
    }

    @Override
    public void startDocument() throws SAXException {
        if (this.ownerDocument == null) {
            this.ownerDocument = documentBuilder.newDocument();
            this.nodeStack.push(this.ownerDocument);
        }
    }

    public Document getDocument() {
        return this.ownerDocument;
    }

    public void setAppendElement(Element appendElement) {
        this.ownerDocument = appendElement.getOwnerDocument();
        this.nodeStack.push(appendElement);
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        Element newElement = null;
        int attsCount = atts.getLength();
        Node currentNode = (Node)this.nodeStack.peek();
        try {
            newElement = namespaceURI != null && qName != null && !qName.equals("") ? this.ownerDocument.createElementNS(namespaceURI.intern(), qName) : this.ownerDocument.createElement(localName.intern());
            currentNode.appendChild(newElement);
            if (!this.emptyElements.contains(qName != null ? qName.toLowerCase() : localName.toLowerCase())) {
                this.nodeStack.push(newElement);
            }
        }
        catch (DOMException e) {
            logger.error((Object)("DOMException creating start element: namespaceURI=" + namespaceURI + ", localName=" + localName), (Throwable)e);
            throw e;
        }
        int i = 0;
        while (i < attsCount) {
            String attNamespace = atts.getURI(i);
            String attQName = atts.getQName(i);
            String attLocalName = atts.getLocalName(i);
            String attValue = atts.getValue(i);
            try {
                if (attNamespace != null && attQName != null) {
                    if ((attNamespace = attNamespace.intern()).equals("")) {
                        if (attQName.startsWith("xmlns")) {
                            attNamespace = "http://www.w3.org/2000/xmlns/";
                        } else if (attQName.startsWith("xml:")) {
                            attNamespace = "http://www.w3.org/XML/1998/namespace";
                        }
                    }
                    newElement.setAttributeNS(attNamespace, attQName, attValue);
                } else {
                    newElement.setAttribute(attLocalName.intern(), attValue);
                }
            }
            catch (DOMException e) {
                logger.error((Object)("DOMException setting element attribute " + attLocalName + "=" + attValue + "[namespaceURI=" + namespaceURI + ", localName=" + localName + "]."), (Throwable)e);
                throw e;
            }
            ++i;
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        String elName = qName != null && !qName.equals("") ? qName.toLowerCase() : localName.toLowerCase();
        if (!this.emptyElements.contains(elName)) {
            int index = this.getIndex(elName);
            if (index != -1) {
                this.nodeStack.setSize(index);
            } else {
                logger.warn((Object)("Ignoring unexpected end [" + localName + "] element event. Request: [" + this.execContext.getDocumentSource() + "] - document location: [" + this.getCurPath() + "]"));
            }
        }
    }

    private String getCurPath() {
        StringBuffer path = new StringBuffer();
        int stackSize = this.nodeStack.size();
        int i = 0;
        while (i < stackSize) {
            Node node = (Node)this.nodeStack.elementAt(i);
            if (node.getNodeType() == 1) {
                path.append('/').append(((Element)node).getTagName());
            }
            ++i;
        }
        return path.toString();
    }

    private int getIndex(String elName) {
        int i = this.nodeStack.size() - 1;
        while (i >= 0) {
            Element element;
            Node node = (Node)this.nodeStack.elementAt(i);
            if (node.getNodeType() == 1 && (element = (Element)node).getTagName().toLowerCase().equals(elName)) {
                return i;
            }
            --i;
        }
        return -1;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            Node currentNode = (Node)this.nodeStack.peek();
            switch (currentNode.getNodeType()) {
                case 1: {
                    if (this.inEntity && !this.rewriteEntities) {
                        currentNode.appendChild(this.ownerDocument.createTextNode("&#" + ch[start] + ";"));
                        break;
                    }
                    currentNode.appendChild(this.ownerDocument.createTextNode(new String(ch, start, length)));
                    break;
                }
                case 4: {
                    this.cdataNodeBuilder.append(ch, start, length);
                    break;
                }
            }
        }
        catch (DOMException e) {
            logger.error((Object)("DOMException appending character data [" + new String(ch, start, length) + "]"), (Throwable)e);
            throw e;
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.characters(ch, start, length);
    }

    @Override
    public void startCDATA() throws SAXException {
        CDATASection newCDATASection = this.ownerDocument.createCDATASection("dummy");
        Node currentNode = (Node)this.nodeStack.peek();
        currentNode.appendChild(newCDATASection);
        this.nodeStack.push(newCDATASection);
        this.cdataNodeBuilder.setLength(0);
    }

    @Override
    public void endCDATA() throws SAXException {
        CDATASection cdata = (CDATASection)this.nodeStack.pop();
        cdata.setData(this.cdataNodeBuilder.toString());
        this.cdataNodeBuilder.setLength(0);
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
        try {
            Node currentNode = (Node)this.nodeStack.peek();
            Comment newComment = this.ownerDocument.createComment(new String(ch, start, length));
            currentNode.appendChild(newComment);
        }
        catch (DOMException e) {
            logger.error((Object)("DOMException comment data [" + new String(ch, start, length) + "]"), (Throwable)e);
            throw e;
        }
    }

    @Override
    public void startEntity(String name) throws SAXException {
        this.inEntity = true;
    }

    @Override
    public void endEntity(String name) throws SAXException {
        this.inEntity = false;
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        DocumentType docType = documentBuilder.getDOMImplementation().createDocumentType(name, publicId, systemId);
        this.ownerDocument.appendChild(docType);
        DocType.setDocType(name, publicId, systemId, null, this.execContext);
    }
}

