/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.delivery.dom.serialize;

import java.io.IOException;
import java.io.Writer;
import org.milyn.cdr.annotation.ConfigParam;
import org.milyn.container.ExecutionContext;
import org.milyn.delivery.dom.serialize.SerializationUnit;
import org.milyn.xml.XmlUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class DefaultSerializationUnit
implements SerializationUnit {
    private boolean closeEmptyElements = false;
    private boolean rewriteEntities;

    @ConfigParam(defaultVal="false")
    public void setCloseEmptyElements(boolean closeEmptyElements) {
        this.closeEmptyElements = closeEmptyElements;
    }

    @ConfigParam(name="entities.rewrite", defaultVal="true")
    public void setRewriteEntities(boolean rewriteEntities) {
        this.rewriteEntities = rewriteEntities;
    }

    public boolean isRewriteEntities() {
        return this.rewriteEntities;
    }

    @Override
    public void writeElementStart(Element element, Writer writer, ExecutionContext executionContext) throws IOException {
        this.writeElementStart(element, writer);
    }

    public void writeElementStart(Element element, Writer writer) throws IOException {
        writer.write(60);
        writer.write(element.getTagName());
        this.writeAttributes(element.getAttributes(), writer);
        if (!this.closeEmptyElements || element.hasChildNodes()) {
            writer.write(62);
        }
    }

    protected void writeAttributes(NamedNodeMap attributes, Writer writer) throws IOException {
        int attribCount = attributes.getLength();
        int i = 0;
        while (i < attribCount) {
            Attr attribute = (Attr)attributes.item(i);
            String attribValue = attribute.getValue();
            int enclosingChar = 34;
            writer.write(32);
            writer.write(attribute.getName());
            writer.write(61);
            if (this.rewriteEntities) {
                writer.write(34);
                XmlUtil.encodeAttributeValue(attribValue.toCharArray(), 0, attribValue.length(), writer);
                writer.write(34);
            } else {
                if (attribValue.indexOf(34) != -1) {
                    enclosingChar = 39;
                }
                writer.write(enclosingChar);
                writer.write(attribValue);
                writer.write(enclosingChar);
            }
            ++i;
        }
    }

    public void writeElementEnd(Element element, Writer writer) throws IOException {
        this.writeElementEnd(element, writer, null);
    }

    @Override
    public void writeElementEnd(Element element, Writer writer, ExecutionContext executionContext) throws IOException {
        if (this.closeEmptyElements && !element.hasChildNodes()) {
            writer.write("/>");
        } else {
            writer.write("</");
            writer.write(element.getTagName());
            writer.write(62);
        }
    }

    @Override
    public void writeElementText(Text text, Writer writer, ExecutionContext executionContext) throws IOException {
        if (this.rewriteEntities) {
            String textString = text.getData();
            XmlUtil.encodeTextValue(textString.toCharArray(), 0, textString.length(), writer);
        } else {
            writer.write(text.getData());
        }
    }

    @Override
    public void writeElementComment(Comment comment, Writer writer, ExecutionContext executionContext) throws IOException {
        writer.write("<!--");
        writer.write(comment.getData());
        writer.write("-->");
    }

    @Override
    public void writeElementEntityRef(EntityReference entityRef, Writer writer, ExecutionContext executionContext) throws IOException {
        writer.write(38);
        writer.write(entityRef.getNodeName());
        writer.write(59);
    }

    @Override
    public void writeElementCDATA(CDATASection cdata, Writer writer, ExecutionContext executionContext) throws IOException {
        writer.write("<![CDATA[");
        writer.write(cdata.getData());
        writer.write("]]>");
    }

    @Override
    public void writeElementNode(Node node, Writer writer, ExecutionContext executionContext) throws IOException {
        throw new IOException("writeElementNode not implemented yet. Node: " + node.getNodeValue() + ", node: [" + node + "]");
    }

    @Override
    public boolean writeChildElements() {
        return true;
    }
}

