/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.delivery.sax;

import java.io.IOException;
import org.milyn.SmooksException;
import org.milyn.cdr.annotation.ConfigParam;
import org.milyn.container.ExecutionContext;
import org.milyn.delivery.sax.SAXElement;
import org.milyn.delivery.sax.SAXElementVisitor;
import org.milyn.delivery.sax.SAXText;
import org.milyn.delivery.sax.SAXVisitor;
import org.milyn.delivery.sax.WriterUtil;

public class DefaultSAXElementSerializer
implements SAXElementVisitor {
    private SAXVisitor writerOwner = this;
    private boolean rewriteEntities = true;

    public void setWriterOwner(SAXVisitor writerOwner) {
        this.writerOwner = writerOwner;
    }

    @ConfigParam(name="entities.rewrite", defaultVal="true")
    public void setRewriteEntities(boolean rewriteEntities) {
        this.rewriteEntities = rewriteEntities;
    }

    @Override
    public void visitBefore(SAXElement element, ExecutionContext executionContext) throws SmooksException, IOException {
        element.getWriter(this.writerOwner);
    }

    @Override
    public void onChildText(SAXElement element, SAXText text, ExecutionContext executionContext) throws SmooksException, IOException {
        this.writeStartElement(element);
        if (element.isWriterOwner(this.writerOwner)) {
            text.toWriter(element.getWriter(this.writerOwner), this.rewriteEntities);
        }
    }

    @Override
    public void onChildElement(SAXElement element, SAXElement childElement, ExecutionContext executionContext) throws SmooksException, IOException {
        this.writeStartElement(element);
    }

    @Override
    public void visitAfter(SAXElement element, ExecutionContext executionContext) throws SmooksException, IOException {
        this.writeEndElement(element);
    }

    public void writeStartElement(SAXElement element) throws IOException {
        if (element.isWriterOwner(this.writerOwner) && !this.isStartWritten(element)) {
            element.setCache(this, true);
            WriterUtil.writeStartElement(element, element.getWriter(this.writerOwner), this.rewriteEntities);
        }
    }

    private void writeEndElement(SAXElement element) throws IOException {
        if (element.isWriterOwner(this.writerOwner)) {
            if (!this.isStartWritten(element)) {
                WriterUtil.writeEmptyElement(element, element.getWriter(this.writerOwner), this.rewriteEntities);
            } else {
                WriterUtil.writeEndElement(element, element.getWriter(this.writerOwner));
            }
        }
    }

    public boolean isStartWritten(SAXElement element) {
        return element.getCache(this) != null;
    }
}

