/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.javabean;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.milyn.SmooksException;
import org.milyn.assertion.AssertArgument;
import org.milyn.cdr.Parameter;
import org.milyn.cdr.SmooksConfigurationException;
import org.milyn.cdr.SmooksResourceConfiguration;
import org.milyn.cdr.annotation.AppContext;
import org.milyn.cdr.annotation.Config;
import org.milyn.cdr.annotation.ConfigParam;
import org.milyn.container.ApplicationContext;
import org.milyn.container.ExecutionContext;
import org.milyn.delivery.annotation.Initialize;
import org.milyn.delivery.dom.DOMElementVisitor;
import org.milyn.delivery.ordering.Producer;
import org.milyn.delivery.sax.SAXElement;
import org.milyn.delivery.sax.SAXVisitAfter;
import org.milyn.delivery.sax.SAXVisitBefore;
import org.milyn.event.report.annotation.VisitAfterReport;
import org.milyn.event.report.annotation.VisitBeforeReport;
import org.milyn.expression.MVELExpressionEvaluator;
import org.milyn.javabean.BeanRuntimeInfo;
import org.milyn.javabean.BeanUtils;
import org.milyn.javabean.repository.BeanId;
import org.milyn.javabean.repository.BeanIdRegister;
import org.milyn.javabean.repository.BeanRepository;
import org.milyn.javabean.repository.BeanRepositoryManager;
import org.milyn.util.CollectionsUtil;
import org.w3c.dom.Element;

@VisitBeforeReport(summary="Created <b>${resource.parameters.beanId!'undefined'}</b> bean instance.  Associated lifecycle if wired to another bean.", detailTemplate="reporting/BeanInstanceCreatorReport_Before.html")
@VisitAfterReport(condition="parameters.containsKey('setOn') || parameters.beanClass.value.endsWith('[]')", summary="Ended bean lifecycle. Set bean on any targets.", detailTemplate="reporting/BeanInstanceCreatorReport_After.html")
public class BeanInstanceCreator
implements DOMElementVisitor,
SAXVisitBefore,
SAXVisitAfter,
Producer {
    private static Log logger = LogFactory.getLog(BeanInstanceCreator.class);
    public static final String INIT_VAL_EXPRESSION = "initValExpression";
    private String id;
    @ConfigParam(name="beanId")
    private String beanIdName;
    @ConfigParam(name="beanClass")
    private String beanClassName;
    @Config
    private SmooksResourceConfiguration config;
    @AppContext
    private ApplicationContext appContext;
    private BeanRuntimeInfo beanRuntimeInfo;
    private BeanRepositoryManager beanRepositoryManager;
    private BeanId beanId;
    private MVELExpressionEvaluator initValsExpression;

    public BeanInstanceCreator() {
    }

    public BeanInstanceCreator(String beanId, Class beanClass) {
        AssertArgument.isNotNull(beanId, "beanId");
        AssertArgument.isNotNull(beanClass, "beanClass");
        this.beanIdName = beanId;
        this.beanClassName = !beanClass.isArray() ? beanClass.getName() : String.valueOf(beanClass.getComponentType().getName()) + "[]";
    }

    public String getBeanId() {
        return this.beanIdName;
    }

    @Initialize
    public void initialize() throws SmooksConfigurationException {
        List<Parameter> initValExpressions;
        this.buildId();
        this.beanRepositoryManager = BeanRepositoryManager.getInstance(this.appContext);
        BeanIdRegister beanIdRegister = this.beanRepositoryManager.getBeanIdRegister();
        this.beanId = beanIdRegister.register(this.beanIdName);
        this.beanRuntimeInfo = BeanRuntimeInfo.getBeanRuntimeInfo(this.beanIdName, this.beanClassName, this.appContext);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("BeanInstanceCreator created for [" + this.beanIdName + "]. BeanRuntimeInfo: " + this.beanRuntimeInfo));
        }
        if ((initValExpressions = this.config.getParameters(INIT_VAL_EXPRESSION)) != null && !initValExpressions.isEmpty()) {
            StringBuilder initValsExpressionString = new StringBuilder();
            for (Parameter initValExpression : initValExpressions) {
                initValsExpressionString.append(initValExpression.getValue());
                initValsExpressionString.append("\n");
            }
            this.initValsExpression = new MVELExpressionEvaluator();
            this.initValsExpression.setExpression(initValsExpressionString.toString());
        }
    }

    public BeanRuntimeInfo getBeanRuntimeInfo() {
        return this.beanRuntimeInfo;
    }

    private void buildId() {
        StringBuilder idBuilder = new StringBuilder();
        idBuilder.append(BeanInstanceCreator.class.getName());
        idBuilder.append("#");
        idBuilder.append(this.beanIdName);
        this.id = idBuilder.toString();
    }

    @Override
    public void visitBefore(Element element, ExecutionContext executionContext) throws SmooksException {
        this.createAndSetBean(executionContext);
    }

    @Override
    public void visitBefore(SAXElement element, ExecutionContext executionContext) throws SmooksException, IOException {
        this.createAndSetBean(executionContext);
    }

    @Override
    public void visitAfter(Element element, ExecutionContext executionContext) throws SmooksException {
        this.visitAfter(executionContext);
    }

    @Override
    public void visitAfter(SAXElement element, ExecutionContext executionContext) throws SmooksException, IOException {
        this.visitAfter(executionContext);
    }

    public void visitAfter(ExecutionContext executionContext) {
        BeanRepository beanRepo = BeanRepositoryManager.getBeanRepository(executionContext);
        BeanRuntimeInfo.Classification thisBeanType = this.beanRuntimeInfo.getClassification();
        boolean isBeanTypeArray = thisBeanType == BeanRuntimeInfo.Classification.ARRAY_COLLECTION;
        beanRepo.setBeanInContext(this.beanId, false);
        if (isBeanTypeArray) {
            Object bean = beanRepo.getBean(this.beanId);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Converting bean [" + this.beanIdName + "] to an array and rebinding to context."));
            }
            bean = this.convert(executionContext, bean);
        }
    }

    private Object convert(ExecutionContext executionContext, Object bean) {
        bean = BeanUtils.convertListToArray((List)bean, this.beanRuntimeInfo.getArrayType());
        BeanRepositoryManager.getBeanRepository(executionContext).changeBean(this.beanId, bean);
        return bean;
    }

    private void createAndSetBean(ExecutionContext executionContext) {
        BeanRepository beanRepo = BeanRepositoryManager.getBeanRepository(executionContext);
        Object bean = this.createBeanInstance();
        if (this.initValsExpression != null) {
            this.initValsExpression.exec(bean);
        }
        beanRepo.setBeanInContext(this.beanId, false);
        beanRepo.addBean(this.beanId, bean);
        beanRepo.setBeanInContext(this.beanId, true);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Bean [" + this.beanIdName + "] instance created."));
        }
    }

    private Object createBeanInstance() {
        Object bean;
        try {
            bean = this.beanRuntimeInfo.getPopulateType().newInstance();
        }
        catch (InstantiationException e) {
            throw new SmooksConfigurationException("Unable to create bean instance [" + this.beanIdName + ":" + this.beanRuntimeInfo.getPopulateType().getName() + "].", e);
        }
        catch (IllegalAccessException e) {
            throw new SmooksConfigurationException("Unable to create bean instance [" + this.beanIdName + ":" + this.beanRuntimeInfo.getPopulateType().getName() + "].", e);
        }
        return bean;
    }

    @Override
    public Set<? extends Object> getProducts() {
        return CollectionsUtil.toSet(this.beanIdName);
    }

    private String getId() {
        return this.id;
    }

    public String toString() {
        return this.getId();
    }
}

