/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.javabean.context;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.milyn.SmooksException;
import org.milyn.cdr.Parameter;
import org.milyn.cdr.SmooksConfigurationException;
import org.milyn.cdr.SmooksResourceConfiguration;
import org.milyn.cdr.annotation.AppContext;
import org.milyn.cdr.annotation.Config;
import org.milyn.container.ApplicationContext;
import org.milyn.container.ExecutionContext;
import org.milyn.delivery.annotation.Initialize;
import org.milyn.delivery.dom.DOMElementVisitor;
import org.milyn.delivery.sax.SAXElement;
import org.milyn.delivery.sax.SAXElementVisitor;
import org.milyn.delivery.sax.SAXText;
import org.milyn.javabean.repository.BeanId;
import org.milyn.javabean.repository.BeanIdRegister;
import org.milyn.javabean.repository.BeanRepository;
import org.milyn.javabean.repository.BeanRepositoryManager;
import org.w3c.dom.Element;

public class StaticVariableBinder
implements SAXElementVisitor,
DOMElementVisitor {
    private static final String STATVAR = "statvar";
    private BeanRepositoryManager beanRepositoryManager;
    private BeanId beanId;
    @Config
    private SmooksResourceConfiguration config;
    @AppContext
    private ApplicationContext appContext;

    @Initialize
    public void initialize() throws SmooksConfigurationException {
        this.beanRepositoryManager = BeanRepositoryManager.getInstance(this.appContext);
        BeanIdRegister beanIdRegister = this.beanRepositoryManager.getBeanIdRegister();
        this.beanId = beanIdRegister.getBeanId(STATVAR);
        if (this.beanId == null) {
            this.beanId = this.beanRepositoryManager.getBeanIdRegister().register(STATVAR);
        }
    }

    @Override
    public void visitBefore(SAXElement element, ExecutionContext executionContext) throws SmooksException, IOException {
        this.bindParamaters(executionContext);
    }

    @Override
    public void onChildText(SAXElement element, SAXText childText, ExecutionContext executionContext) throws SmooksException, IOException {
    }

    @Override
    public void onChildElement(SAXElement element, SAXElement childElement, ExecutionContext executionContext) throws SmooksException, IOException {
    }

    @Override
    public void visitAfter(SAXElement element, ExecutionContext executionContext) throws SmooksException, IOException {
    }

    @Override
    public void visitBefore(Element element, ExecutionContext executionContext) throws SmooksException {
        this.bindParamaters(executionContext);
    }

    @Override
    public void visitAfter(Element element, ExecutionContext executionContext) throws SmooksException {
    }

    private void bindParamaters(ExecutionContext executionContext) {
        List params = this.config.getParameterList();
        for (Object parameter : params) {
            if (parameter instanceof List) {
                this.bindParameter((Parameter)((List)parameter).get(0), executionContext);
                continue;
            }
            if (!(parameter instanceof Parameter)) continue;
            this.bindParameter((Parameter)parameter, executionContext);
        }
    }

    private void bindParameter(Parameter parameter, ExecutionContext executionContext) {
        HashMap<String, Object> params = null;
        BeanRepository beanRepository = BeanRepositoryManager.getBeanRepository(executionContext);
        try {
            HashMap<String, Object> castParams;
            params = castParams = (HashMap<String, Object>)beanRepository.getBean(this.beanId);
        }
        catch (ClassCastException e) {
            throw new SmooksException("Illegal use of reserved beanId 'statvar'.  Must be a Map.  Is a " + params.getClass().getName(), e);
        }
        if (params == null) {
            params = new HashMap<String, Object>();
            beanRepository.addBean(this.beanId, params);
        }
        params.put(parameter.getName(), parameter.getValue(executionContext.getDeliveryConfig()));
    }
}

