/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.javabean.lifecycle;

import org.milyn.assertion.AssertArgument;
import org.milyn.container.ExecutionContext;
import org.milyn.javabean.lifecycle.BeanLifecycle;
import org.milyn.javabean.lifecycle.BeanLifecycleObserver;
import org.milyn.javabean.lifecycle.BeanLifecycleSubject;
import org.milyn.javabean.lifecycle.BeanRepositoryLifecycleObserver;
import org.milyn.javabean.repository.BeanId;
import org.milyn.javabean.repository.BeanRepositoryManager;

public class BeanLifecycleSubjectGroup {
    private final BeanLifecycleSubject beginLifecycleNotifier;
    private final BeanLifecycleSubject changeLifecycleNotifier;
    private final BeanId beanId;
    private final ExecutionContext executionContext;

    public BeanLifecycleSubjectGroup(ExecutionContext executionContext, BeanId beanId) {
        AssertArgument.isNotNull(executionContext, "executionContext");
        AssertArgument.isNotNull(beanId, "beanId");
        this.executionContext = executionContext;
        this.beanId = beanId;
        this.beginLifecycleNotifier = new BeanLifecycleSubject(executionContext, BeanLifecycle.BEGIN, beanId);
        this.changeLifecycleNotifier = new BeanLifecycleSubject(executionContext, BeanLifecycle.CHANGE, beanId);
    }

    @Deprecated
    public BeanLifecycleSubjectGroup(ExecutionContext executionContext, String beanId) {
        this(executionContext, BeanLifecycleSubjectGroup.getBeanId(executionContext, beanId));
    }

    @Deprecated
    public void addObserver(BeanLifecycle lifecycle, String observerId, boolean notifyOnce, BeanLifecycleObserver observer) {
        this.getBeanObserverNotifier(lifecycle).addObserver(observerId, notifyOnce, observer);
    }

    public void addObserver(BeanLifecycle lifecycle, String observerId, boolean notifyOnce, BeanRepositoryLifecycleObserver observer) {
        this.getBeanObserverNotifier(lifecycle).addObserver(observerId, notifyOnce, observer);
    }

    public void removeObserver(BeanLifecycle lifecycle, String observerId) {
        this.getBeanObserverNotifier(lifecycle).removeObserver(observerId);
    }

    public void notifyObservers(BeanLifecycle lifecycle, Object bean) {
        this.getBeanObserverNotifier(lifecycle).notifyObservers(bean);
    }

    protected BeanLifecycleSubject getBeanObserverNotifier(BeanLifecycle lifecycle) {
        switch (lifecycle) {
            case BEGIN: {
                return this.beginLifecycleNotifier;
            }
            case CHANGE: {
                return this.changeLifecycleNotifier;
            }
        }
        throw new IllegalArgumentException("Unknown BeanLifecycle '" + (Object)((Object)lifecycle) + "'");
    }

    @Deprecated
    public String getBeanId() {
        return this.beanId.getName();
    }

    public ExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    private static BeanId getBeanId(ExecutionContext executionContext, String beanId) {
        AssertArgument.isNotNullAndNotEmpty(beanId, "beanId");
        return BeanRepositoryManager.getInstance(executionContext.getContext()).getBeanIdRegister().getBeanId(beanId);
    }
}

