/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.javabean.lifecycle;

import java.util.Map;
import java.util.Set;
import org.milyn.cdr.annotation.ConfigParam;
import org.milyn.container.ExecutionContext;
import org.milyn.delivery.ExecutionLifecycleCleanable;
import org.milyn.delivery.annotation.Initialize;
import org.milyn.javabean.repository.BeanRepository;
import org.milyn.util.CollectionsUtil;

public class BeanResultCleanup
implements ExecutionLifecycleCleanable {
    @ConfigParam
    private String[] beanIDs;
    private Set<String> beanIDSet;

    @Initialize
    public void initialize() {
        this.beanIDSet = CollectionsUtil.toSet(this.beanIDs);
    }

    @Override
    public void executeExecutionLifecycleCleanup(ExecutionContext executionContext) {
        BeanRepository beanRepository = BeanRepository.getInstance(executionContext);
        Set<Map.Entry<String, Object>> beanSet = beanRepository.getBeanMap().entrySet();
        for (Map.Entry<String, Object> beanEntry : beanSet) {
            String beanID = beanEntry.getKey();
            if (this.beanIDSet.contains(beanID)) continue;
            beanRepository.removeBean(beanID);
        }
    }
}

