/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.javabean.pojogen;

import java.util.ArrayList;
import java.util.List;
import org.milyn.assertion.AssertArgument;
import org.milyn.javabean.pojogen.JNamedType;
import org.milyn.javabean.pojogen.JType;

public class JMethod {
    private JType returnType;
    private String methodName;
    private List<JNamedType> parameters = new ArrayList<JNamedType>();
    private String body;

    public JMethod(String methodName) {
        AssertArgument.isNotNull(methodName, "methodName");
        this.returnType = new JType(Void.TYPE);
        this.methodName = methodName;
    }

    public JMethod(JType returnType, String methodName) {
        AssertArgument.isNotNull(returnType, "returnType");
        AssertArgument.isNotNull(methodName, "methodName");
        this.returnType = returnType;
        this.methodName = methodName;
    }

    public JType getReturnType() {
        return this.returnType;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public JMethod addParameter(JType type, String parameterName) {
        return this.addParameter(new JNamedType(type, parameterName));
    }

    public JMethod addParameter(JNamedType parameter) {
        this.parameters.add(parameter);
        return this;
    }

    public List<JNamedType> getParameters() {
        return this.parameters;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public String getSignature() {
        StringBuilder signature = new StringBuilder();
        signature.append(this.returnType);
        signature.append(" ");
        signature.append(this.methodName);
        signature.append("(");
        int i = 0;
        while (i < this.parameters.size()) {
            if (i > 0) {
                signature.append(", ");
            }
            signature.append(this.parameters.get(i));
            ++i;
        }
        signature.append(")");
        return signature.toString();
    }
}

