/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.javabean.repository;

import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import org.milyn.container.ApplicationContext;
import org.milyn.container.ExecutionContext;
import org.milyn.javabean.repository.BeanIdRegister;
import org.milyn.javabean.repository.BeanRepository;
import org.milyn.payload.FilterResult;
import org.milyn.payload.FilterSource;
import org.milyn.payload.JavaResult;
import org.milyn.payload.JavaSource;

public class BeanRepositoryManager {
    private static final String CONTEXT_KEY = String.valueOf(BeanRepositoryManager.class.getName()) + "#CONTEXT_KEY";
    private static final String BEAN_REPOSITORY_CONTEXT_KEY = String.valueOf(BeanRepository.class.getName()) + "#CONTEXT_KEY";
    private final BeanIdRegister beanIdRegister = new BeanIdRegister();

    public static BeanRepositoryManager getInstance(ApplicationContext applicationContext) {
        BeanRepositoryManager beanRepositoryManager = (BeanRepositoryManager)applicationContext.getAttribute(CONTEXT_KEY);
        if (beanRepositoryManager == null) {
            beanRepositoryManager = new BeanRepositoryManager();
            applicationContext.setAttribute(CONTEXT_KEY, beanRepositoryManager);
        }
        return beanRepositoryManager;
    }

    private BeanRepositoryManager() {
    }

    public BeanIdRegister getBeanIdRegister() {
        return this.beanIdRegister;
    }

    public static BeanRepository getBeanRepository(ExecutionContext executionContext) {
        BeanRepository beanRepository = (BeanRepository)executionContext.getAttribute(BEAN_REPOSITORY_CONTEXT_KEY);
        if (beanRepository == null) {
            beanRepository = BeanRepositoryManager.getInstance(executionContext.getContext()).createBeanRepository(executionContext);
            executionContext.setAttribute(BEAN_REPOSITORY_CONTEXT_KEY, beanRepository);
        }
        return beanRepository;
    }

    private BeanRepository createBeanRepository(ExecutionContext executionContext) {
        Map<String, Object> beanMap = this.createBeanMap(executionContext);
        BeanRepository beanRepository = new BeanRepository(executionContext, this.beanIdRegister, beanMap);
        return beanRepository;
    }

    private Map<String, Object> createBeanMap(ExecutionContext executionContext) {
        JavaSource javaSource;
        Map<String, Object> sourceBeans;
        Result result = FilterResult.getResult(executionContext, JavaResult.class);
        Source source = FilterSource.getSource(executionContext);
        Map<String, Object> beanMap = null;
        if (result != null) {
            JavaResult javaResult = (JavaResult)result;
            beanMap = javaResult.getResultMap();
        }
        if (source instanceof JavaSource && (sourceBeans = (javaSource = (JavaSource)source).getBeans()) != null) {
            if (beanMap != null) {
                beanMap.putAll(sourceBeans);
            } else {
                beanMap = sourceBeans;
            }
        }
        if (beanMap == null) {
            beanMap = new HashMap<String, Object>();
        } else {
            for (String beanId : beanMap.keySet()) {
                if (this.beanIdRegister.containsBeanId(beanId)) continue;
                this.beanIdRegister.register(beanId);
            }
        }
        return beanMap;
    }
}

