/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.conf;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jgroups.util.PrintXMLTree;
import org.jgroups.util.Util;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlValidator {
    private final String mXmlUrl;
    private final String mDtdUrl;
    private final boolean mPrintXml;

    public XmlValidator(String xmlUrl, String dtdUrl) {
        this(xmlUrl, dtdUrl, true);
    }

    public XmlValidator(String xmlUrl, String dtdUrl, boolean printXml) {
        this.mXmlUrl = xmlUrl;
        this.mDtdUrl = dtdUrl;
        this.mPrintXml = printXml;
    }

    protected static InputStream getInputStream(String url) throws IOException {
        URL inurl = new URL(url);
        return inurl.openStream();
    }

    public void validate() throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setEntityResolver(new JGEntityResolver(this.mDtdUrl));
        JGErrorHandler errorhandler = new JGErrorHandler();
        builder.setErrorHandler(errorhandler);
        Document document = builder.parse(XmlValidator.getInputStream(this.mXmlUrl));
        if (this.mPrintXml) {
            PrintXMLTree.print(new PrintWriter(System.out), document.getDocumentElement());
        }
        System.out.println("\n\nError Report:");
        System.out.println(errorhandler.getErrorString());
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.out.println("Usage: XmlValidator xmlUrl dtdUrl [printXml(true|false)]");
            System.out.println("Example: XmlValidator file:/usr/local/test.xml file:conf/jgroups-protocol.dtd false");
            System.exit(1);
        }
        boolean printXml = true;
        if (args.length > 2) {
            try {
                printXml = Boolean.valueOf(args[2]);
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
        XmlValidator xmlValidator = new XmlValidator(args[0], args[1], printXml);
        xmlValidator.validate();
    }

    class JGErrorHandler
    implements ErrorHandler {
        private final StringBuffer mErrors = new StringBuffer();
        int count = 1;

        JGErrorHandler() {
        }

        public void warning(SAXParseException exception) throws SAXException {
            this.mErrors.append('\n').append(this.count++).append(". WARNING: ");
            this.mErrors.append(Util.getStackTrace(exception));
            this.mErrors.append('\n');
        }

        public void error(SAXParseException exception) throws SAXException {
            this.mErrors.append('\n').append(this.count++).append(". ERROR: ");
            this.mErrors.append(Util.getStackTrace(exception));
            this.mErrors.append('\n');
        }

        public void fatalError(SAXParseException exception) throws SAXException {
            this.mErrors.append('\n').append(this.count++).append(". FATAL ERROR: ");
            this.mErrors.append(Util.getStackTrace(exception));
            this.mErrors.append('\n');
        }

        public String getErrorString() {
            if (this.mErrors.length() == 0) {
                return "No errors reported.";
            }
            return this.mErrors.toString();
        }
    }

    class JGEntityResolver
    implements EntityResolver {
        private final String mDtdUrl;

        public JGEntityResolver(String dtdUrl) {
            this.mDtdUrl = dtdUrl;
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            InputSource source = new InputSource(XmlValidator.getInputStream(this.mDtdUrl));
            return source;
        }
    }
}

