/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.cleaner;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.cleaner.LNInfo;
import com.sleepycat.je.cleaner.UtilizationProfile;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.utilint.TestHook;
import com.sleepycat.je.utilint.TestHookExecute;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSelector {
    private SortedSet<Long> toBeCleanedFiles = new TreeSet<Long>();
    private Set<Long> beingCleanedFiles;
    private Set<Long> cleanedFiles = new HashSet<Long>();
    private Map<Long, Set<DatabaseId>> cleanedFilesDatabases = new HashMap<Long, Set<DatabaseId>>();
    private Set<Long> checkpointedFiles = new HashSet<Long>();
    private Set<Long> fullyProcessedFiles = new HashSet<Long>();
    private Set<Long> safeToDeleteFiles = new HashSet<Long>();
    private Map<Long, LNInfo> pendingLNs = new HashMap<Long, LNInfo>();
    private Set<DatabaseId> pendingDBs = new HashSet<DatabaseId>();
    private boolean anyPendingDuringCheckpoint;
    private Set<Long> lowUtilizationFiles = Collections.emptySet();
    private TestHook fileChosenHook;

    FileSelector() {
        this.beingCleanedFiles = new HashSet<Long>();
    }

    public void setFileChosenHook(TestHook hook) {
        this.fileChosenHook = hook;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Long selectFileForCleaning(UtilizationProfile profile, boolean forceCleaning, boolean calcLowUtilizationFiles, int maxBatchFiles) throws DatabaseException {
        TreeSet<Long> availableFiles;
        FileSelector fileSelector;
        Object fileNum;
        HashSet<Long> newLowUtilizationFiles = calcLowUtilizationFiles ? new HashSet<Long>() : null;
        while (true) {
            int toBeCleanedSize;
            FileSelector fileSelector2 = this;
            synchronized (fileSelector2) {
                toBeCleanedSize = this.toBeCleanedFiles.size();
            }
            if (maxBatchFiles > 0 && toBeCleanedSize >= maxBatchFiles || (fileNum = profile.getBestFileForCleaning(this, forceCleaning, newLowUtilizationFiles, toBeCleanedSize > 0)) == null) break;
            assert (TestHookExecute.doHookIfSet(this.fileChosenHook));
            fileSelector = this;
            synchronized (fileSelector) {
                if (!this.isFileCleaningInProgress((Long)fileNum)) {
                    this.toBeCleanedFiles.add((Long)fileNum);
                }
            }
        }
        if (newLowUtilizationFiles != null) {
            this.lowUtilizationFiles = newLowUtilizationFiles;
        }
        fileNum = this;
        synchronized (fileNum) {
            availableFiles = new TreeSet<Long>(this.toBeCleanedFiles);
        }
        while (availableFiles.size() > 0) {
            fileNum = profile.getCheapestFileToClean(availableFiles);
            if (fileNum == null) {
                return null;
            }
            fileSelector = this;
            synchronized (fileSelector) {
                if (this.toBeCleanedFiles.remove(fileNum)) {
                    this.beingCleanedFiles.add((Long)fileNum);
                    return fileNum;
                }
                availableFiles.remove(fileNum);
            }
        }
        return null;
    }

    synchronized boolean isFileCleaningInProgress(Long file) {
        return this.toBeCleanedFiles.contains(file) || this.beingCleanedFiles.contains(file) || this.cleanedFiles.contains(file) || this.checkpointedFiles.contains(file) || this.fullyProcessedFiles.contains(file) || this.safeToDeleteFiles.contains(file);
    }

    private boolean isFileCleaningInProgress(Collection<Long> files) {
        for (Long file : files) {
            if (!this.isFileCleaningInProgress(file)) continue;
            return true;
        }
        return false;
    }

    synchronized void removeAllFileReferences(Long file, MemoryBudget budget) {
        this.toBeCleanedFiles.remove(file);
        this.beingCleanedFiles.remove(file);
        this.cleanedFiles.remove(file);
        Set<DatabaseId> oldDatabases = this.cleanedFilesDatabases.remove(file);
        this.adjustMemoryBudget(budget, oldDatabases, null);
        this.checkpointedFiles.remove(file);
        this.fullyProcessedFiles.remove(file);
        this.safeToDeleteFiles.remove(file);
    }

    synchronized void putBackFileForCleaning(Long fileNum) {
        this.beingCleanedFiles.remove(fileNum);
        assert (!this.isFileCleaningInProgress(fileNum));
        this.toBeCleanedFiles.add(fileNum);
    }

    synchronized void injectFileForCleaning(Long fileNum) {
        if (!this.isFileCleaningInProgress(fileNum)) {
            this.toBeCleanedFiles.add(fileNum);
        }
    }

    synchronized void addCleanedFile(Long fileNum, Set<DatabaseId> databases, MemoryBudget budget) {
        this.beingCleanedFiles.remove(fileNum);
        assert (!this.isFileCleaningInProgress(fileNum));
        this.cleanedFiles.add(fileNum);
        Set<DatabaseId> oldDatabases = this.cleanedFilesDatabases.put(fileNum, databases);
        this.adjustMemoryBudget(budget, oldDatabases, databases);
    }

    Set<Long> getLowUtilizationFiles() {
        return this.lowUtilizationFiles;
    }

    synchronized Set<Long> getMustBeCleanedFiles() {
        HashSet<Long> set = new HashSet<Long>(this.toBeCleanedFiles);
        set.addAll(this.beingCleanedFiles);
        return set;
    }

    synchronized int getBacklog() {
        return this.toBeCleanedFiles.size();
    }

    synchronized CheckpointStartCleanerState getFilesAtCheckpointStart() {
        this.anyPendingDuringCheckpoint = !this.pendingLNs.isEmpty() || !this.pendingDBs.isEmpty();
        CheckpointStartCleanerState info = new CheckpointStartCleanerState(this.cleanedFiles, this.fullyProcessedFiles);
        return info;
    }

    synchronized void updateFilesAtCheckpointEnd(CheckpointStartCleanerState info) {
        if (!info.isEmpty()) {
            Set<Long> previouslyProcessedFiles;
            Set<Long> previouslyCleanedFiles = info.getCleanedFiles();
            if (previouslyCleanedFiles != null) {
                this.cleanedFiles.removeAll(previouslyCleanedFiles);
                assert (!this.isFileCleaningInProgress(previouslyCleanedFiles));
                if (this.anyPendingDuringCheckpoint) {
                    this.checkpointedFiles.addAll(previouslyCleanedFiles);
                } else {
                    this.safeToDeleteFiles.addAll(previouslyCleanedFiles);
                }
            }
            if ((previouslyProcessedFiles = info.getFullyProcessedFiles()) != null) {
                this.fullyProcessedFiles.removeAll(previouslyProcessedFiles);
                assert (!this.isFileCleaningInProgress(this.fullyProcessedFiles));
                this.safeToDeleteFiles.addAll(previouslyProcessedFiles);
            }
            this.updateProcessedFiles();
        }
    }

    synchronized boolean addPendingLN(LN ln, DatabaseId dbId, byte[] key, byte[] dupKey) {
        assert (ln != null);
        boolean added = this.pendingLNs.put(ln.getNodeId(), new LNInfo(ln, dbId, key, dupKey)) != null;
        this.anyPendingDuringCheckpoint = true;
        return added;
    }

    synchronized LNInfo[] getPendingLNs() {
        if (this.pendingLNs.size() > 0) {
            LNInfo[] lns = new LNInfo[this.pendingLNs.size()];
            this.pendingLNs.values().toArray(lns);
            return lns;
        }
        return null;
    }

    synchronized void removePendingLN(long nodeId) {
        this.pendingLNs.remove(nodeId);
        this.updateProcessedFiles();
    }

    synchronized boolean addPendingDB(DatabaseId dbId) {
        boolean added = this.pendingDBs.add(dbId);
        this.anyPendingDuringCheckpoint = true;
        return added;
    }

    synchronized DatabaseId[] getPendingDBs() {
        if (this.pendingDBs.size() > 0) {
            DatabaseId[] dbs = new DatabaseId[this.pendingDBs.size()];
            this.pendingDBs.toArray(dbs);
            return dbs;
        }
        return null;
    }

    synchronized void removePendingDB(DatabaseId dbId) {
        this.pendingDBs.remove(dbId);
        this.updateProcessedFiles();
    }

    synchronized Set<Long> copySafeToDeleteFiles() {
        if (this.safeToDeleteFiles.size() == 0) {
            return null;
        }
        return new HashSet<Long>(this.safeToDeleteFiles);
    }

    synchronized Set<DatabaseId> getCleanedDatabases(Long fileNum) {
        return new HashSet<DatabaseId>((Collection)this.cleanedFilesDatabases.get(fileNum));
    }

    synchronized void removeDeletedFile(Long fileNum, MemoryBudget budget) {
        this.safeToDeleteFiles.remove(fileNum);
        assert (!this.isFileCleaningInProgress(fileNum));
        Set<DatabaseId> oldDatabases = this.cleanedFilesDatabases.remove(fileNum);
        this.adjustMemoryBudget(budget, oldDatabases, null);
    }

    synchronized void close(MemoryBudget budget) {
        for (Set<DatabaseId> oldDatabases : this.cleanedFilesDatabases.values()) {
            this.adjustMemoryBudget(budget, oldDatabases, null);
        }
    }

    private void updateProcessedFiles() {
        if (this.pendingLNs.isEmpty() && this.pendingDBs.isEmpty()) {
            this.fullyProcessedFiles.addAll(this.checkpointedFiles);
            this.checkpointedFiles.clear();
        }
    }

    private void adjustMemoryBudget(MemoryBudget budget, Set<DatabaseId> oldDatabases, Set<DatabaseId> newDatabases) {
        long adjustMem = 0L;
        if (oldDatabases != null) {
            adjustMem -= this.getCleanedFilesDatabaseEntrySize(oldDatabases);
        }
        if (newDatabases != null) {
            adjustMem += this.getCleanedFilesDatabaseEntrySize(newDatabases);
        }
        budget.updateAdminMemoryUsage(adjustMem);
    }

    private long getCleanedFilesDatabaseEntrySize(Set<DatabaseId> databases) {
        return MemoryBudget.HASHMAP_ENTRY_OVERHEAD + MemoryBudget.HASHSET_OVERHEAD + databases.size() * MemoryBudget.HASHSET_ENTRY_OVERHEAD;
    }

    public String toString() {
        return "toBeCleanedFiles = " + this.toBeCleanedFiles + " beingCleanedFiles = " + this.beingCleanedFiles + " cleanedFiles = " + this.cleanedFiles + " cleanedFilesDatabases = " + this.cleanedFilesDatabases + " checkpointedFiles = " + this.checkpointedFiles + " fullyProcessedFiles = " + this.fullyProcessedFiles + " safeToDeleteFiles = " + this.safeToDeleteFiles + " pendingLNs = " + this.pendingLNs + " pendingDBs = " + this.pendingDBs + " anyPendingDuringCheckpoint = " + this.anyPendingDuringCheckpoint + " lowUtilizationFiles = " + this.lowUtilizationFiles;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CheckpointStartCleanerState {
        private Set<Long> cleanedFiles;
        private Set<Long> fullyProcessedFiles;

        CheckpointStartCleanerState(Set<Long> cleanedFiles, Set<Long> fullyProcessedFiles) {
            this.cleanedFiles = new HashSet<Long>(cleanedFiles);
            this.fullyProcessedFiles = new HashSet<Long>(fullyProcessedFiles);
        }

        public boolean isEmpty() {
            return this.cleanedFiles.size() == 0 && this.fullyProcessedFiles.size() == 0;
        }

        public Set<Long> getCleanedFiles() {
            return this.cleanedFiles;
        }

        public Set<Long> getFullyProcessedFiles() {
            return this.fullyProcessedFiles;
        }
    }
}

