/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.repository.rules;

import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.jcip.annotations.Immutable;
import org.jboss.dna.common.component.ComponentConfig;
import org.jboss.dna.common.util.ArgCheck;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class RuleSet
extends ComponentConfig
implements Cloneable {
    private final String providerUri;
    private final String ruleSetUri;
    private final String rules;
    private final Map<String, Object> properties;

    public RuleSet(String name, String description, String classname, String[] classpath, String providerUri, String ruleSetUri, String rules, Map<String, Object> properties) {
        super(name, description, System.currentTimeMillis(), classname, classpath);
        if (ruleSetUri == null) {
            ruleSetUri = name.trim();
        }
        ArgCheck.isNotEmpty((String)ruleSetUri, (String)"rule set URI");
        ArgCheck.isNotEmpty((String)providerUri, (String)"provider URI");
        ArgCheck.isNotEmpty((String)rules, (String)"rules");
        this.providerUri = providerUri;
        this.ruleSetUri = ruleSetUri;
        this.rules = rules;
        if (properties == null) {
            properties = Collections.emptyMap();
        }
        this.properties = Collections.unmodifiableMap(properties);
    }

    public String getProviderUri() {
        return this.providerUri;
    }

    public String getRuleSetUri() {
        return this.ruleSetUri;
    }

    public String getRules() {
        return this.rules;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public Map<Object, Object> getExecutionSetProperties() {
        HashMap<Object, Object> props = new HashMap<Object, Object>();
        for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof byte[]) {
                value = new InputStreamReader(new ByteArrayInputStream((byte[])value));
            }
            props.put(key, value);
        }
        return props;
    }

    public boolean hasChanged(ComponentConfig obj) {
        if (super.hasChanged(obj)) {
            return true;
        }
        RuleSet that = (RuleSet)obj;
        if (!this.providerUri.equals(that.providerUri)) {
            return true;
        }
        return !this.ruleSetUri.equals(that.ruleSetUri);
    }

    public RuleSet clone() {
        return new RuleSet(this.getName(), this.getDescription(), this.getComponentClassname(), this.getComponentClasspathArray(), this.providerUri, this.ruleSetUri, this.rules, this.properties);
    }
}

