/*
 * Copyright 2013 JBoss by Red Hat.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jbpm.executor;

import javax.inject.Named;

import org.kie.internal.executor.api.Command;
import org.kie.internal.executor.api.CommandContext;
import org.kie.internal.executor.api.ExecutionResults;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


@Named(value="ThrowExceptionCmd")
public class ThrowExceptionCommand implements Command{
    
    private static final Logger logger = LoggerFactory.getLogger(ThrowExceptionCommand.class);

    public ExecutionResults execute(CommandContext ctx) {
        logger.debug("Hi This is the Exception command!");
        throw new RuntimeException("Test Exception!");        
    }
    
}
