/*
 * Decompiled with CFR 0.152.
 */
package com.birosoft.liquid;

import com.birosoft.liquid.LiquidLookAndFeel;
import com.birosoft.liquid.skin.Skin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicProgressBarUI;

public class LiquidProgressBarUI
extends BasicProgressBarUI {
    static Skin skinHorizontal;
    static Skin skinVertical;
    private static Skin skinTrackVert;
    private static Skin skinTrackHoriz;
    private Skin skinTrack;
    private static Skin skinThumbVert;
    private static Skin skinThumbHoriz;
    private static Skin disabledSkinThumbVert;
    private static Skin disabledSkinThumbHoriz;
    private Skin skinThumb;
    int offset = 3;

    public static ComponentUI createUI(JComponent c) {
        return new LiquidProgressBarUI();
    }

    protected void paintDeterminate(Graphics g, JComponent c) {
        if (!(g instanceof Graphics2D)) {
            return;
        }
        int index = 0;
        Insets b = this.progressBar.getInsets();
        int barRectWidth = this.progressBar.getWidth() - (b.right + b.left);
        int barRectHeight = this.progressBar.getHeight() - (b.top + b.bottom);
        Graphics2D g2 = (Graphics2D)g;
        if (this.progressBar.getOrientation() == 0) {
            int amountFull = this.getAmountFull(b, barRectWidth, barRectHeight);
            this.getSkinTrack().draw(g, 0, 0, 0, barRectWidth, barRectHeight);
            Paint p = g2.getPaint();
            if (amountFull > 10) {
                this.getSkinThumb().draw(g, index, 0, 0, amountFull, barRectHeight);
            }
            if (this.progressBar.isStringPainted()) {
                g.setColor(Color.black);
                this.paintString(g, b.left, b.top, barRectWidth, barRectHeight, amountFull, b);
            }
            g2.setPaint(p);
        } else {
            int amountFull = this.getAmountFull(b, barRectWidth, barRectHeight);
            this.getSkinTrack().draw(g, 0, 0, 0, barRectWidth, barRectHeight);
            Paint p = g2.getPaint();
            if (amountFull > 10) {
                this.getSkinThumb().draw(g, index, 0, barRectHeight - amountFull, barRectWidth, amountFull);
            }
            if (this.progressBar.isStringPainted()) {
                g.setColor(Color.black);
                this.paintString(g, b.left, b.top, barRectWidth, barRectHeight, amountFull, b);
            }
            g2.setPaint(p);
        }
    }

    protected void paintIndeterminate(Graphics g, JComponent c) {
        if (!(g instanceof Graphics2D)) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        int index = 0;
        Insets b = this.progressBar.getInsets();
        int barRectWidth = this.progressBar.getWidth() - (b.right + b.left);
        int barRectHeight = this.progressBar.getHeight() - (b.top + b.bottom);
        Rectangle boxRect = this.getBox(null);
        if (this.progressBar.getOrientation() == 0) {
            this.getSkinTrack().draw(g, 0, 0, 0, barRectWidth, barRectHeight);
            g.translate(boxRect.x, boxRect.y);
            this.getSkinThumb().draw(g, index, 0, 0, boxRect.width, barRectHeight);
            g.translate(-boxRect.x, -boxRect.y);
        } else {
            this.getSkinTrack().draw(g, 0, 0, 0, barRectWidth, barRectHeight);
            g.translate(boxRect.x, boxRect.y);
            this.getSkinThumb().draw(g, index, barRectWidth, boxRect.height);
            g.translate(-boxRect.x, -boxRect.y);
        }
    }

    public void update(Graphics g, JComponent c) {
        this.paint(g, c);
    }

    protected void installDefaults() {
        LiquidLookAndFeel.installColorsAndFont(this.progressBar, "ProgressBar.background", "ProgressBar.foreground", "ProgressBar.font");
    }

    protected Dimension getPreferredInnerHorizontal() {
        Dimension horizDim = (Dimension)UIManager.get("ProgressBar.horizontalSize");
        if (horizDim == null) {
            horizDim = new Dimension(146, 14);
        }
        return horizDim;
    }

    protected Dimension getPreferredInnerVertical() {
        Dimension vertDim = (Dimension)UIManager.get("ProgressBar.vertictalSize");
        if (vertDim == null) {
            vertDim = new Dimension(14, 146);
        }
        return vertDim;
    }

    public static Skin getSkinThumbHoriz() {
        if (skinThumbHoriz == null) {
            skinThumbHoriz = new Skin("scrollbarthumbhoriz.png", 4, 8, 6, 8, 8);
        }
        return skinThumbHoriz;
    }

    public static Skin getSkinThumbVert() {
        if (skinThumbVert == null) {
            skinThumbVert = new Skin("scrollbarthumbvert.png", 4, 6, 8, 8, 7);
        }
        return skinThumbVert;
    }

    public static Skin getDisabledSkinThumbHoriz() {
        if (disabledSkinThumbHoriz == null) {
            disabledSkinThumbHoriz = new Skin("scrollbarthumbhoriz.png", 4, 8, 6, 8, 8);
            disabledSkinThumbHoriz.colourImage();
        }
        return disabledSkinThumbHoriz;
    }

    public static Skin getDisabledSkinThumbVert() {
        if (disabledSkinThumbVert == null) {
            disabledSkinThumbVert = new Skin("scrollbarthumbvert.png", 4, 6, 8, 8, 7);
            disabledSkinThumbVert.colourImage();
        }
        return disabledSkinThumbVert;
    }

    public static Skin getSkinTrackHoriz() {
        if (skinTrackHoriz == null) {
            skinTrackHoriz = new Skin("progressbartrackhoriz.png", 1, 7);
        }
        return skinTrackHoriz;
    }

    public static Skin getSkinTrackVert() {
        if (skinTrackVert == null) {
            skinTrackVert = new Skin("progressbartrackvert.png", 1, 7);
        }
        return skinTrackVert;
    }

    public Skin getSkinTrack() {
        if (this.skinTrack == null) {
            this.skinTrack = this.progressBar.getOrientation() == 1 ? LiquidProgressBarUI.getSkinTrackVert() : LiquidProgressBarUI.getSkinTrackHoriz();
        }
        return this.skinTrack;
    }

    public Skin getSkinThumb() {
        if (this.skinThumb == null) {
            this.skinThumb = this.progressBar.isEnabled() ? (this.progressBar.getOrientation() == 1 ? LiquidProgressBarUI.getSkinThumbVert() : LiquidProgressBarUI.getSkinThumbHoriz()) : (this.progressBar.getOrientation() == 1 ? LiquidProgressBarUI.getDisabledSkinThumbVert() : LiquidProgressBarUI.getDisabledSkinThumbHoriz());
        }
        return this.skinThumb;
    }
}

