/*
 * Copyright 2015 JBoss Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
*/

package org.kie.workbench.common.widgets.client.datamodel.testclasses;

import java.util.List;

/**
 * Test class to check data-types are extracted correctly by ProjectDataModelOracleBuilder for subclasses and delegated classes
 */
public class TestSuperClass {

    private String field1;

    public String getField1() {
        return field1;
    }

    public void setField1( final String field1 ) {
        this.field1 = field1;
    }

    public List<String> getList() {
        return null;
    }

    public static class NestedClass {

        private String nestedField1;

        public String getNestedField1() {
            return nestedField1;
        }

        public void setNestedField1( final String nestedField1 ) {
            this.nestedField1 = nestedField1;
        }

        public String methodDoingSomethingWithNestedField1() {
            return this.nestedField1;
        }

        public NestedClass methodDoingSomethingThatReturnsAnInnerClass() {
            return null;
        }

        public Product methodDoingSomethingThatReturnsAnOuterClass() {
            return null;
        }

    }

}
