/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf.nimbus.painters;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import javax.swing.JSplitPane;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthPainter;
import org.jdesktop.swingx.plaf.nimbus.NimbusGraphicsUtils;

public class SplitPanePainter
extends SynthPainter {
    private boolean fill = true;
    private static final BufferedImage vert_img = NimbusGraphicsUtils.loadImage("split_pane_vertical.png");
    private static final BufferedImage horz_img = NimbusGraphicsUtils.loadImage("split_pane_horizontal.png");

    public SplitPanePainter() {
    }

    public SplitPanePainter(boolean fill) {
        this.fill = fill;
    }

    @Override
    public void paintSplitPaneBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
    }

    @Override
    public void paintSplitPaneBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
    }

    @Override
    public void paintSplitPaneDividerBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
    }

    @Override
    public void paintSplitPaneDividerBackground(SynthContext context, Graphics g, int x, int y, int w, int h, int orientation) {
        --w;
        --h;
        if (this.fill) {
            g.setColor(new Color(214, 217, 223));
            g.fillRect(x, y, w, h);
        }
        JSplitPane splitPane = (JSplitPane)context.getComponent();
        if (orientation == 0) {
            System.out.println("VERTICAL");
            System.out.println(w);
            g.setColor(new Color(239, 240, 242));
            g.drawLine(x, y, x + w, y);
            g.setColor(new Color(230, 232, 236));
            g.drawLine(x, y + h, x + w, y + h);
            g.drawImage(vert_img, (w - vert_img.getWidth()) / 2, y + 2, vert_img.getWidth(), vert_img.getHeight(), splitPane);
        } else {
            g.setColor(new Color(239, 240, 242));
            g.drawLine(x, y, x, y + h);
            g.setColor(new Color(230, 232, 236));
            g.drawLine(x + w, y, x + w, y + h);
            g.drawImage(horz_img, x + 2, (h - horz_img.getHeight()) / 2, horz_img.getWidth(), horz_img.getHeight(), splitPane);
        }
    }

    @Override
    public void paintSplitPaneDividerForeground(SynthContext context, Graphics g, int x, int y, int w, int h, int orientation) {
    }

    @Override
    public void paintSplitPaneDragDivider(SynthContext context, Graphics g, int x, int y, int w, int h, int orientation) {
        this.paintSplitPaneDividerBackground(context, g, x, y, w, h, orientation);
    }
}

