/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.convert;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.convert.MessageFactory;

public class FloatConverter
implements Converter {
    public static final String CONVERTER_ID = "javax.faces.Float";
    public static final String FLOAT_ID = "javax.faces.converter.FloatConverter.FLOAT";
    public static final String STRING_ID = "javax.faces.converter.STRING";

    public Object getAsObject(FacesContext context, UIComponent component, String value) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            return null;
        }
        if ((value = value.trim()).length() < 1) {
            return null;
        }
        try {
            return Float.valueOf(value);
        }
        catch (NumberFormatException nfe) {
            throw new ConverterException(MessageFactory.getMessage((FacesContext)context, (String)FLOAT_ID, (Object[])new Object[]{value, "2000000000", MessageFactory.getLabel((FacesContext)context, (UIComponent)component)}), (Throwable)nfe);
        }
        catch (Exception e) {
            throw new ConverterException((Throwable)e);
        }
    }

    public String getAsString(FacesContext context, UIComponent component, Object value) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            return "";
        }
        if (value instanceof String) {
            return (String)value;
        }
        try {
            return Float.toString(((Number)value).floatValue());
        }
        catch (Exception e) {
            throw new ConverterException(MessageFactory.getMessage((FacesContext)context, (String)STRING_ID, (Object[])new Object[]{value, MessageFactory.getLabel((FacesContext)context, (UIComponent)component)}), (Throwable)e);
        }
    }
}

