/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.lafwidget.scroll;

import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.plaf.basic.ComboPopup;
import org.jvnet.lafwidget.LafWidgetAdapter;
import org.jvnet.lafwidget.LafWidgetRepository;
import org.jvnet.lafwidget.LafWidgetUtilities2;
import org.jvnet.lafwidget.preview.PreviewPainter;
import org.jvnet.lafwidget.scroll.ScrollPaneSelector;

public class ScrollPaneSelectorWidget
extends LafWidgetAdapter {
    protected JScrollPane scrollPane;
    protected ScrollPaneSelector scrollPaneSelector;
    protected HierarchyListener hierarchyListener;
    protected PropertyChangeListener propertyChangeListener;

    public void setComponent(JComponent jcomp) {
        super.setComponent(jcomp);
        this.scrollPane = (JScrollPane)jcomp;
    }

    public boolean requiresCustomLafSupport() {
        return false;
    }

    public void installUI() {
        if (LafWidgetRepository.getRepository().getLafSupport().toInstallExtraElements(this.scrollPane)) {
            PreviewPainter pPainter = LafWidgetUtilities2.getComponentPreviewPainter(this.scrollPane);
            if (pPainter == null) {
                return;
            }
            this.scrollPaneSelector = new ScrollPaneSelector();
            this.scrollPaneSelector.installOnScrollPane(this.scrollPane);
        }
    }

    public void uninstallUI() {
        if (this.scrollPaneSelector != null) {
            this.scrollPaneSelector.uninstallFromScrollPane();
            this.scrollPaneSelector = null;
        }
    }

    public void installListeners() {
        this.hierarchyListener = new HierarchyListener(){

            public void hierarchyChanged(HierarchyEvent e) {
                if (ScrollPaneSelectorWidget.this.scrollPane.getParent() instanceof ComboPopup && ScrollPaneSelectorWidget.this.scrollPaneSelector != null) {
                    ScrollPaneSelectorWidget.this.scrollPaneSelector.uninstallFromScrollPane();
                    ScrollPaneSelectorWidget.this.scrollPaneSelector = null;
                }
            }
        };
        this.scrollPane.addHierarchyListener(this.hierarchyListener);
        this.propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("lafwidgets.componentPreviewPainter".equals(evt.getPropertyName())) {
                    PreviewPainter pPainter = LafWidgetUtilities2.getComponentPreviewPainter(ScrollPaneSelectorWidget.this.scrollPane);
                    if (ScrollPaneSelectorWidget.this.scrollPaneSelector != null) {
                        ScrollPaneSelectorWidget.this.scrollPaneSelector.uninstallFromScrollPane();
                        ScrollPaneSelectorWidget.this.scrollPaneSelector = null;
                    }
                    if (pPainter != null) {
                        ScrollPaneSelectorWidget.this.scrollPaneSelector = new ScrollPaneSelector();
                        ScrollPaneSelectorWidget.this.scrollPaneSelector.installOnScrollPane(ScrollPaneSelectorWidget.this.scrollPane);
                    }
                }
            }
        };
        this.scrollPane.addPropertyChangeListener(this.propertyChangeListener);
    }

    public void uninstallListeners() {
        this.scrollPane.removeHierarchyListener(this.hierarchyListener);
        this.hierarchyListener = null;
        this.scrollPane.removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
    }
}

