/*
 * Copyright 2016 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.kie.workbench.common.forms.dynamic.client.rendering.renderers.selectors.listBox;

import javax.enterprise.context.Dependent;

import org.jboss.errai.databinding.client.api.Converter;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.selectors.CharacterSelectorOption;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.selectors.listBox.definition.CharacterListBoxFieldDefinition;

@Dependent
public class CharacterListBoxFieldRenderer
        extends AbstractListBoxFieldRenderer<CharacterListBoxFieldDefinition, CharacterSelectorOption, Character> {

    @Override
    public Class<CharacterListBoxFieldDefinition> getSupportedFieldDefinition() {
        return CharacterListBoxFieldDefinition.class;
    }

    @Override
    public Character getEmptyValue() {
        return ' ';
    }

    @Override
    public Converter getConverter() {
        return null;
    }
}
