/*
 * Copyright 2015 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.kie.workbench.common.widgets.client.discussion;

import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;

public class CommentLineViewImpl extends Composite
        implements CommentLineView {

    interface Binder
            extends
            UiBinder<Widget, CommentLineViewImpl> {

    }

    private static Binder uiBinder = GWT.create( Binder.class );

    @UiField
    Label author;

    @UiField
    Label date;

    @UiField
    Label comment;

    private Presenter presenter;

    public CommentLineViewImpl( ) {
        initWidget( uiBinder.createAndBindUi( this ) );
    }

    public void setPresenter( Presenter presenter ) {
        this.presenter = presenter;
    }

    @Override
    public void setAuthor( String author ) {
        this.author.setText( author );
    }

    @Override
    public void setComment( String comment ) {
        this.comment.setText( comment );
    }

    @Override
    public void setDate( String date ) {
        this.date.setText( date );
    }
}

