/*
 * Copyright 2016 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.kie.workbench.common.screens.datasource.management.client.dbexplorer.dbobjects;

public class DatabaseObjectRow {

    private String name;

    private String type;

    public DatabaseObjectRow( String name, String type ) {
        this.name = name;
        this.type = type;
    }

    public String getName( ) {
        return name;
    }

    public void setName( String name ) {
        this.name = name;
    }

    public String getType( ) {
        return type;
    }

    public void setType( String type ) {
        this.type = type;
    }

    @Override
    public boolean equals( Object o ) {
        if ( this == o ) return true;
        if ( o == null || getClass( ) != o.getClass( ) ) return false;

        DatabaseObjectRow that = ( DatabaseObjectRow ) o;

        if ( name != null ? !name.equals( that.name ) : that.name != null ) return false;
        return type != null ? type.equals( that.type ) : that.type == null;

    }

    @Override
    public int hashCode( ) {
        int result = name != null ? name.hashCode( ) : 0;
        result = ~~result;
        result = 31 * result + ( type != null ? type.hashCode( ) : 0 );
        result = ~~result;
        return result;
    }
}
