/*
 * Copyright 2016 Red Hat, Inc. and/or its affiliates.
 *  
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *  
 *    http://www.apache.org/licenses/LICENSE-2.0
 *  
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.uberfire.ext.security.management.validation;

import java.util.ResourceBundle;

import org.uberfire.ext.security.management.api.validation.UserValidator;

public class UserValidatorImpl extends UserValidator {

    private static final String BUNDLE_PREFFIX = "user.validation.";
    private static final ResourceBundle MESSAGES = ResourceBundle.getBundle("org.uberfire.ext.security.management.UberfireSecurityManagementMessages");

    @Override
    public String getMessage(String key) {
        return MESSAGES.getString(BUNDLE_PREFFIX + key);
    }
}
