/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.util;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;

public class CDataEndEscapeFilterWriter
extends FilterWriter {
    private char c1;
    private char c2;
    private int pos = 0;

    public CDataEndEscapeFilterWriter(Writer out) {
        super(out);
    }

    @Override
    public void write(int c) throws IOException {
        super.write(c);
        this.c1 = this.c2;
        this.c2 = (char)c;
        ++this.pos;
        if (this.pos > 2 && this.c1 == ']' && this.c2 == ']' && c == 62) {
            this.out.write("<![CDATA[]]]]><![CDATA[>");
        }
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        int index = off;
        for (int i = 0; i < len; ++i) {
            char c = cbuf[off + i];
            if (this.c1 == ']' && this.c2 == ']' && c == '>') {
                super.write(cbuf, index, i + 1 - (index - off));
                index = off + i + 1;
                this.out.write("<![CDATA[]]]]><![CDATA[>");
            }
            this.c1 = this.c2;
            this.c2 = cbuf[off + i];
            ++this.pos;
        }
        if (index < off + len) {
            super.write(cbuf, index, off + len - index);
        }
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        int index = off;
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(off + i);
            if (this.c1 == ']' && this.c2 == ']' && c == '>') {
                super.write(str, index, i + 1 - (index - off));
                index = off + i + 1;
                this.out.write("<![CDATA[]]]]><![CDATA[>");
            }
            this.c1 = this.c2;
            this.c2 = str.charAt(off + i);
            ++this.pos;
        }
        if (index < off + len) {
            super.write(str, index, off + len - index);
        }
    }
}

