/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import oracle.core.lmx.CoreException;
import oracle.jdbc.driver.ByteArray;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.VarnumBinder;

class FloatBinder
extends VarnumBinder {
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;

    FloatBinder() {
    }

    @Override
    long bind(OraclePreparedStatement oraclePreparedStatement, int n2, int n3, int n4, byte[] byArray, char[] cArray, short[] sArray, int n5, int n6, int n7, int n8, int n9, int n10, boolean bl, long l2, ByteArray byteArray, long[] lArray, int[] nArray, int n11, boolean bl2, int n12) throws SQLException {
        byte[] byArray2 = null;
        int n13 = 0;
        double d2 = oraclePreparedStatement.parameterDouble[n4][n2];
        long l3 = 0L;
        if (bl2) {
            lArray[n11] = l3 = byteArray.getPosition();
            oraclePreparedStatement.lastBoundDataOffsets[n2] = l3;
            byArray2 = oraclePreparedStatement.connection.methodTempLittleByteBuffer;
            n13 = 0;
        } else {
            byArray2 = byArray;
            n13 = n7 + 1;
        }
        int n14 = 0;
        if (d2 == 0.0) {
            byArray2[n13] = -128;
            n14 = 1;
        } else if (d2 == Double.POSITIVE_INFINITY) {
            byArray2[n13] = -1;
            byArray2[n13 + 1] = 101;
            n14 = 2;
        } else if (d2 == Double.NEGATIVE_INFINITY) {
            byArray2[n13] = 0;
            n14 = 1;
        } else {
            long l4;
            int n15;
            int n16;
            boolean bl3;
            boolean bl4 = bl3 = d2 < 0.0;
            if (bl3) {
                d2 = -d2;
            }
            if ((n16 = ((n15 = (int)((l4 = Double.doubleToLongBits(d2)) >> 52 & 0x7FFL)) > 1023 ? 126 : 127) - (int)((double)(n15 - 1023) / 6.643856189774725)) < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, CoreException.getMessage((byte)3) + " trying to bind " + d2);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n16 > 192) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, CoreException.getMessage((byte)2) + " trying to bind " + d2);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (d2 > factorTable[n16]) {
                while (n16 > 0 && d2 > factorTable[--n16]) {
                }
            } else {
                while (n16 < 193 && d2 <= factorTable[n16 + 1]) {
                    ++n16;
                }
            }
            if (d2 == factorTable[n16]) {
                if (n16 < 65) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, CoreException.getMessage((byte)3) + " trying to bind " + d2);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (n16 > 192) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, CoreException.getMessage((byte)2) + " trying to bind " + d2);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (bl3) {
                    byArray2[n13] = (byte)(62 - (127 - n16));
                    byArray2[n13 + 1] = 100;
                    byArray2[n13 + 2] = 102;
                    n14 = 3;
                } else {
                    byArray2[n13] = (byte)(192 + (128 - n16));
                    byArray2[n13 + 1] = 2;
                    n14 = 2;
                }
            } else {
                int n17;
                if (n16 < 64) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, CoreException.getMessage((byte)3) + " trying to bind " + d2);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (n16 > 191) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, CoreException.getMessage((byte)2) + " trying to bind " + d2);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                int n18 = Float.floatToIntBits((float)d2);
                int n19 = n18 & 0x7FFFFF;
                int n20 = n18 >> 23 & 0xFF;
                char[] cArray2 = oraclePreparedStatement.digits;
                if (n20 == 0) {
                    while ((long)(n19 & 0x800000) == 0L) {
                        n19 <<= 1;
                        --n20;
                    }
                    n17 = 24 + n20;
                    ++n20;
                } else {
                    n19 |= 0x800000;
                    n17 = 24;
                }
                n14 = this.dtoa(byArray2, n13, d2, bl3, true, cArray2, n20 -= 127, (long)n19 << 29, n17);
            }
        }
        if (bl2) {
            byteArray.put(byArray2, 0, n14);
            sArray[n10] = 0;
            nArray[n11] = n14;
            oraclePreparedStatement.lastBoundDataLengths[n2] = n14;
        } else {
            byArray2[n7] = (byte)n14;
            sArray[n10] = 0;
        }
        sArray[n9] = (short)(n14 + 1);
        return l2;
    }
}

