/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.scroll;

import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import org.jvnet.substance.border.SimplisticSoftBorderPainter;
import org.jvnet.substance.border.StandardBorderPainter;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceSizeUtils;

public class SubstanceScrollPaneBorder
implements Border,
UIResource {
    public Insets getBorderInsets(Component c) {
        float borderStrokeWidth = SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(c));
        int ins = (int)borderStrokeWidth;
        return new Insets(ins, ins, ins, ins);
    }

    public boolean isBorderOpaque() {
        return false;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        if (!(c instanceof JScrollPane)) {
            return;
        }
        JScrollPane scrollPane = (JScrollPane)c;
        JScrollBar vertical = scrollPane.getVerticalScrollBar();
        JScrollBar horizontal = scrollPane.getHorizontalScrollBar();
        SimplisticSoftBorderPainter painter = new SimplisticSoftBorderPainter();
        ColorScheme scheme = SubstanceCoreUtilities.getDefaultScheme(c);
        float borderStrokeWidth = SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(c));
        int borderDelta = (int)Math.floor((double)SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(c)) / 2.0);
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setStroke(new BasicStroke(borderStrokeWidth, 2, 0));
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        x += borderDelta;
        y += borderDelta;
        width -= 2 * borderDelta;
        height -= 2 * borderDelta;
        if (scrollPane.getComponentOrientation().isLeftToRight()) {
            g2d.setColor(((StandardBorderPainter)painter).getTopBorderColor(scheme, scheme, 0.0, false));
            if (vertical.isVisible()) {
                g2d.drawLine(x, y, x + width - vertical.getWidth(), y);
            } else {
                g2d.drawLine(x, y, x + width, y);
            }
            g2d.setColor(((StandardBorderPainter)painter).getTopBorderColor(scheme, scheme, 0.0, false));
            if (horizontal.isVisible()) {
                g2d.drawLine(x, y, x, y + height - horizontal.getHeight());
            } else {
                g2d.drawLine(x, y, x, y + height);
            }
            g2d.setColor(((StandardBorderPainter)painter).getBottomBorderColor(scheme, scheme, 0.0, false));
            if (!horizontal.isVisible()) {
                if (vertical.isVisible()) {
                    g2d.drawLine(x, y + height - 1, x + width - vertical.getWidth(), y + height - 1);
                } else {
                    g2d.drawLine(x, y + height - 1, x + width, y + height - 1);
                }
            }
            g2d.setColor(((StandardBorderPainter)painter).getBottomBorderColor(scheme, scheme, 0.0, false));
            if (!vertical.isVisible()) {
                if (horizontal.isVisible()) {
                    g2d.drawLine(x + width - 1, y, x + width - 1, y + height - horizontal.getHeight());
                } else {
                    g2d.drawLine(x + width - 1, y, x + width - 1, y + height);
                }
            }
        } else {
            g2d.setColor(((StandardBorderPainter)painter).getTopBorderColor(scheme, scheme, 0.0, false));
            if (vertical.isVisible()) {
                g2d.drawLine(x + vertical.getWidth(), y, x + width, y);
            } else {
                g2d.drawLine(x, y, x + width, y);
            }
            g2d.setColor(((StandardBorderPainter)painter).getBottomBorderColor(scheme, scheme, 0.0, false));
            if (!vertical.isVisible()) {
                if (horizontal.isVisible()) {
                    g2d.drawLine(x, y, x, y + height - horizontal.getHeight());
                } else {
                    g2d.drawLine(x, y, x, y + height - 1);
                }
            }
            g2d.setColor(((StandardBorderPainter)painter).getBottomBorderColor(scheme, scheme, 0.0, false));
            if (!horizontal.isVisible()) {
                if (vertical.isVisible()) {
                    g2d.drawLine(x + vertical.getWidth(), y + height - 1, x + width, y + height - 1);
                } else {
                    g2d.drawLine(x, y + height - 1, x + width, y + height - 1);
                }
            }
            g2d.setColor(((StandardBorderPainter)painter).getTopBorderColor(scheme, scheme, 0.0, false));
            if (horizontal.isVisible()) {
                g2d.drawLine(x + width - 1, y, x + width - 1, y + height - horizontal.getHeight());
            } else {
                g2d.drawLine(x + width - 1, y, x + width - 1, y + height);
            }
        }
        g2d.dispose();
    }
}

