/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.title;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.WeakHashMap;
import org.jvnet.substance.SubstanceImageCreator;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.title.SubstanceTitlePainter;
import org.jvnet.substance.utils.SubstanceColorUtilities;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

public class RandomCubesTitlePainter
implements SubstanceTitlePainter {
    public static final String DISPLAY_NAME = "Random Cubes";
    public static final int CUBE_DIMENSION = 5;
    private static WeakHashMap<Component, CubeColors> cubeColorMap = new WeakHashMap();

    private static double[][] getCubeColorMatrix(int width, int height) {
        int cubeCountY = height / 5;
        int cubeCountX = 1 + width / 5;
        double[][] result = new double[cubeCountX][cubeCountY];
        for (int col = 0; col < cubeCountX; ++col) {
            for (int row = 0; row < cubeCountY; ++row) {
                if (Math.random() < 0.45) {
                    result[col][row] = -1.0;
                    continue;
                }
                double coef = 1.0 - ((double)col / (double)cubeCountX + 0.9 * (Math.random() - 0.5));
                coef = Math.max(0.0, coef);
                result[col][row] = coef = Math.min(1.0, coef);
            }
        }
        return result;
    }

    private static BufferedImage getCubes(int width, int height, boolean isDark, Color leftTransColor, Color rightTransColor, double[][] colorMatrix) {
        BufferedImage image = SubstanceCoreUtilities.getBlankImage(width, height);
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        int cubeCountY = Math.min(height / 5, colorMatrix[0].length);
        int cubeCountX = Math.min(1 + width / 5, colorMatrix.length);
        int cubeStartY = height % 5 / 2;
        int cubeStartX = 0;
        for (int col = 0; col < cubeCountX; ++col) {
            for (int row = 0; row < cubeCountY; ++row) {
                double coef = colorMatrix[col][row];
                if (coef < 0.0) continue;
                int r = (int)(coef * (double)leftTransColor.getRed() + (1.0 - coef) * (double)rightTransColor.getRed());
                int g = (int)(coef * (double)leftTransColor.getGreen() + (1.0 - coef) * (double)rightTransColor.getGreen());
                int b = (int)(coef * (double)leftTransColor.getBlue() + (1.0 - coef) * (double)rightTransColor.getBlue());
                Color cubeColor = new Color(r, g, b);
                graphics.setColor(cubeColor);
                graphics.fillRect(cubeStartX + col * 5, cubeStartY + row * 5, 5, 5);
                if (isDark) {
                    graphics.setColor(SubstanceColorUtilities.getDarkerColor(cubeColor, 0.2));
                } else {
                    graphics.setColor(SubstanceColorUtilities.getLighterColor(cubeColor, 0.2));
                }
                graphics.drawRect(cubeStartX + col * 5, cubeStartY + row * 5, 5, 5);
            }
        }
        return image;
    }

    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    public void paintTitleBackground(Graphics2D graphics, Component comp, int width, int height, int leftTitleX, int rightTitleX, SubstanceTheme theme, float borderAlpha) {
        Object cubesLeft;
        int leftTransitionStart = leftTitleX - 10;
        int leftTransitionEnd = leftTitleX + 10;
        int rightTransitionStart = rightTitleX - 10;
        int rightTransitionEnd = rightTitleX + 10;
        HashMap<Integer, Color> waypoints = new HashMap<Integer, Color>();
        Color colorEnd = theme.getColorScheme().getMidColor();
        Color colorTrans = theme.getColorScheme().getLightColor();
        Color colorMid = theme.getColorScheme().getExtraLightColor();
        waypoints.put(leftTransitionStart, colorTrans);
        waypoints.put(leftTransitionEnd, colorMid);
        waypoints.put(rightTransitionStart, colorMid);
        waypoints.put(rightTransitionEnd, colorTrans);
        BufferedImage lineEven = SubstanceImageCreator.getOneLineGradient(width + 1, colorEnd, colorEnd, waypoints);
        for (int row = 0; row < height; ++row) {
            graphics.drawImage((Image)lineEven, 0, row, null);
        }
        CubeColors cubeColors = cubeColorMap.get(comp);
        if (cubeColors == null) {
            cubesLeft = null;
            if (leftTransitionStart < leftTransitionEnd) {
                cubesLeft = RandomCubesTitlePainter.getCubeColorMatrix(leftTransitionEnd - leftTransitionStart, height);
            }
            double[][] cubesRight = null;
            if (rightTransitionStart < rightTransitionEnd) {
                cubesRight = RandomCubesTitlePainter.getCubeColorMatrix(rightTransitionEnd - rightTransitionStart, height);
            }
            cubeColors = new CubeColors();
            cubeColors.leftTransitionMatrix = cubesLeft;
            cubeColors.rightTransitionMatrix = cubesRight;
            cubeColorMap.put(comp, cubeColors);
        }
        if (cubeColors.leftTransitionMatrix != null) {
            cubesLeft = RandomCubesTitlePainter.getCubes(leftTransitionEnd - leftTransitionStart, height, SubstanceCoreUtilities.isThemeDark(theme), colorEnd, colorMid, cubeColors.leftTransitionMatrix);
            graphics.drawImage((Image)cubesLeft, leftTransitionStart, 0, null);
        }
        if (cubeColors.rightTransitionMatrix != null) {
            BufferedImage cubesRight = RandomCubesTitlePainter.getCubes(rightTransitionEnd - rightTransitionStart, height, SubstanceCoreUtilities.isThemeDark(theme), colorMid, colorEnd, cubeColors.rightTransitionMatrix);
            graphics.drawImage((Image)cubesRight, rightTransitionStart, 0, null);
        }
    }

    private static class CubeColors {
        public double[][] leftTransitionMatrix;
        public double[][] rightTransitionMatrix;

        private CubeColors() {
        }
    }
}

