package com.redhat.installer.tests.asconfiguration.jsf;

import com.redhat.installer.asconfiguration.jsf.VerifyJsfVersionValidator;
import com.redhat.installer.tests.TestUtils;
import org.junit.Before;
import org.junit.Test;

/**
 * Created by thauser on 9/30/16.
 */
public class VerifyJsfVersionValidatorTest extends AbstractVerifyJsfValidatorTest {

    private final String jsfVersionVar = "jsf.version";

    @Before
    public void setUp() throws Exception {
        idata.langpack = TestUtils.createMockLangpack(tempFolder, "empty.fields.version", "JBossJsfSetupPanel.error.NoPom",
                "jsf.version.not.supported", "JBossJsfSetupPanel.setversion", "JBossJsfSetupPanel.error.VersionMatch",
                "JBossJsfSetupPanel.error.JarError");
        dv = new VerifyJsfVersionValidator();
        idata.setVariable("jsf.to.validate.version", "jsfimpl.input");
    }

    @Test
    public void testAutoVersion() {
        idata.setVariable(jsfVersionVar, "");
        assertVersionMatches("2.2.1");
    }


    @Test
    public void testTwoDigitWarn() {
        idata.setVariable(jsfVersionVar, "2.1");
        assertStatusCombinedMsgWarning();
    }


    @Test
    public void testThreeDigitWarn(){
        idata.setVariable(jsfVersionVar, "2.2.2");
        assertStatusCombinedMsgWarning();
    }

    @Test
    public void testTwoDigitMatch(){
        idata.setVariable(jsfVersionVar, "2.2");
        assertStatusOk();
    }

    @Test
    public void testThreeDigitMatch(){
        idata.setVariable(jsfVersionVar, "2.2.1");
        assertStatusOk();
    }

    @Test
    public void testJarError(){
        idata.setVariable(idata.getVariable(toValidateVar), "garbage path that doesn't exist");
        assertStatusError();
    }

    @Test
    public void testEmptyMfAuto(){
        idata.setVariable(apiPathVar, tempFolder.getRoot().getPath() + "/emptyMF.jar");
        idata.setVariable(implPathVar, tempFolder.getRoot().getPath() + "/emptyMF.jar");
        idata.setVariable(jsfVersionVar, "");
        assertStatusError();
    }
    @Test
    public void testEmptyMfInput(){
        idata.setVariable(apiPathVar, tempFolder.getRoot().getPath() + "/emptyMF.jar");
        idata.setVariable(implPathVar, tempFolder.getRoot().getPath() + "/emptyMF.jar");
        idata.setVariable(jsfVersionVar, "2.2");
        assertStatusCombinedMsgWarning();
    }


    @Test
    public void testNoPomMismatch(){
        idata.setVariable(apiPathVar, tempFolder.getRoot().getPath() + "/missingPomMojarraApi.jar");
        idata.setVariable(implPathVar, tempFolder.getRoot().getPath() + "/missingPomMojarraApi.jar");
        idata.setVariable(jsfVersionVar, "2.1");
        assertStatusCombinedMsgWarning();
    }

    @Test
    public void testNoPomMatch(){
        idata.setVariable(apiPathVar, tempFolder.getRoot().getPath() + "/missingPomMojarraApi.jar");
        idata.setVariable(implPathVar, tempFolder.getRoot().getPath() + "/missingPomMojarraApi.jar");
        idata.setVariable(jsfVersionVar, "2.2.1");
        assertStatusOk();

    }
}
